/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Buffer;
import cascading.operation.BufferCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.util.Iterator;

public class TestIdentityBuffer
extends BaseOperation<Integer>
implements Buffer<Integer> {
    private Fields groupFields;
    private Integer numGroups;
    private boolean nullsAreOK;

    public TestIdentityBuffer(Fields groupFields, int numGroups, boolean nullsAreOK) {
        super(Fields.ARGS);
        this.groupFields = groupFields;
        this.numGroups = numGroups;
        this.nullsAreOK = nullsAreOK;
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Integer> operationCall) {
        operationCall.setContext((Object)0);
    }

    public void cleanup(FlowProcess flowProcess, OperationCall<Integer> operationCall) {
        if (!((Integer)operationCall.getContext()).equals(this.numGroups)) {
            throw new RuntimeException("incorrect num groups, found: " + operationCall.getContext() + " expected: " + this.numGroups);
        }
    }

    public void operate(FlowProcess flowProcess, BufferCall<Integer> bufferCall) {
        bufferCall.setContext((Object)((Integer)bufferCall.getContext() + 1));
        TupleEntry group = bufferCall.getGroup();
        if (group.size() != this.groupFields.size()) {
            throw new RuntimeException("group tuple size not fields size");
        }
        if (group.size() == 0) {
            throw new RuntimeException("group tuple size is zero");
        }
        boolean allAreNull = true;
        for (Object o : group.getTuple()) {
            if (o == null) continue;
            allAreNull = false;
        }
        if (!this.nullsAreOK && allAreNull) {
            throw new RuntimeException("group tuple value is null");
        }
        Iterator iterator = bufferCall.getArgumentsIterator();
        while (iterator.hasNext()) {
            bufferCall.getOutputCollector().add((TupleEntry)iterator.next());
        }
    }
}

