/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;

public class TestFunction
extends BaseOperation<Integer>
implements Function<Integer> {
    int failon = -1;
    private Tuple value;
    private boolean isSafe = true;

    public TestFunction(Fields fieldDeclaration, Tuple value, boolean isSafe) {
        super(fieldDeclaration);
        this.value = value;
        this.isSafe = isSafe;
    }

    public TestFunction(Fields fieldDeclaration, Tuple value) {
        super(fieldDeclaration);
        this.value = value;
    }

    public TestFunction(Fields fieldDeclaration, Tuple value, int failon) {
        super(fieldDeclaration);
        this.value = value;
        this.failon = failon;
    }

    public TestFunction(Fields fieldDeclaration, Tuple value, int failon, boolean isSafe) {
        super(fieldDeclaration);
        this.value = value;
        this.failon = failon;
        this.isSafe = isSafe;
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Integer> operationCall) {
        operationCall.setContext((Object)0);
    }

    public void operate(FlowProcess flowProcess, FunctionCall<Integer> functionCall) {
        if (this.value == null) {
            this.throwIntentionalException();
        }
        try {
            if ((Integer)functionCall.getContext() == this.failon) {
                throw new RuntimeException("function failed intentionally on tuple number: " + this.failon);
            }
        }
        finally {
            functionCall.setContext((Object)((Integer)functionCall.getContext() + 1));
        }
        TupleEntry result = functionCall.getDeclaredFields().isUnknown() ? new TupleEntry(Fields.size((int)this.value.size()), Tuple.size((int)this.value.size())) : new TupleEntry(functionCall.getDeclaredFields(), Tuple.size((int)functionCall.getDeclaredFields().size()));
        try {
            result.setCanonicalTuple(this.value);
        }
        catch (Exception exception) {
            result.setCanonicalTuple(Tuple.size((int)this.value.size(), (Comparable)Integer.valueOf(-99)));
        }
        functionCall.getOutputCollector().add(result);
    }

    protected void throwIntentionalException() {
        throw new RuntimeException("function failed intentionally");
    }

    public void cleanup(FlowProcess flowProcess, OperationCall<Integer> operationCall) {
        if (this.value != null && this.value.getObject(0) == null) {
            throw new RuntimeException("tuple was modified");
        }
    }

    public boolean isSafe() {
        return this.isSafe;
    }
}

