/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.CascadingTesting;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.Buffer;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleListCollector;
import cascading.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public abstract class CascadingTestCase
extends TestCase
implements Serializable {
    public static final String ROOT_OUTPUT_PATH = "test.output.root";
    public static final String ROOT_PLAN_PATH = "test.plan.root";
    public static final String TEST_TRACEPLAN_ENABLED = "test.traceplan.enabled";
    private String outputPath;
    private String planPath;
    @Rule
    public transient TestName name = new TestName();

    public CascadingTestCase() {
    }

    public CascadingTestCase(String name) {
        super(name);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (Boolean.getBoolean(TEST_TRACEPLAN_ENABLED)) {
            System.setProperty("cascading.planner.plan.path", Util.join((String)"/", (String[])new String[]{this.getPlanPath(), "planner"}));
            System.setProperty("cascading.planner.plan.transforms.path", Util.join((String)"/", (String[])new String[]{this.getPlanPath(), "planner"}));
            System.setProperty("cascading.planner.stats.path", Util.join((String)"/", (String[])new String[]{this.getPlanPath(), "planner"}));
            System.setProperty("platform.cascading.stream.dotfile.path", Util.join((String)"/", (String[])new String[]{this.getPlanPath(), "stream"}));
        }
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected static String getTestOutputRoot() {
        return System.getProperty(ROOT_OUTPUT_PATH, "build/test/output").replace(":", "_");
    }

    protected static String getTestPlanRoot() {
        return System.getProperty(ROOT_PLAN_PATH, "build/test/plan").replace(":", "_");
    }

    protected String[] getOutputPathElements() {
        return new String[]{CascadingTestCase.getTestOutputRoot(), this.getTestCaseName(), this.getTestName()};
    }

    protected String[] getPlanPathElements() {
        return new String[]{CascadingTestCase.getTestPlanRoot(), this.getTestCaseName(), this.getTestName()};
    }

    protected String getOutputPath() {
        if (this.outputPath == null) {
            this.outputPath = Util.join((Object[])this.getOutputPathElements(), (String)File.separator);
        }
        return this.outputPath;
    }

    protected String getPlanPath() {
        if (this.planPath == null) {
            this.planPath = Util.join((Object[])this.getPlanPathElements(), (String)File.separator);
        }
        return this.planPath;
    }

    public String getTestCaseName() {
        return this.getClass().getSimpleName().replaceAll("^(.*)Test.*$", "$1").toLowerCase();
    }

    public String getTestName() {
        return this.name.getMethodName();
    }

    public static void validateLength(Flow flow, int numTuples) throws IOException {
        CascadingTestCase.validateLength(flow, numTuples, -1);
    }

    public static void validateLength(Flow flow, int numTuples, String name) throws IOException {
        CascadingTestCase.validateLength(flow, numTuples, -1, null, name);
    }

    public static void validateLength(Flow flow, int numTuples, int tupleSize) throws IOException {
        CascadingTestCase.validateLength(flow, numTuples, tupleSize, null, null);
    }

    public static void validateLength(Flow flow, int numTuples, int tupleSize, Pattern regex) throws IOException {
        CascadingTestCase.validateLength(flow, numTuples, tupleSize, regex, null);
    }

    public static void validateLength(Flow flow, int numTuples, Pattern regex, String name) throws IOException {
        CascadingTestCase.validateLength(flow, numTuples, -1, regex, name);
    }

    public static void validateLength(Flow flow, int numTuples, int tupleSize, Pattern regex, String name) throws IOException {
        TupleEntryIterator iterator = name == null ? flow.openSink() : flow.openSink(name);
        CascadingTestCase.validateLength(iterator, numTuples, tupleSize, regex);
    }

    public static void validateLength(TupleEntryIterator iterator, int numTuples) {
        CascadingTestCase.validateLength(iterator, numTuples, -1, null);
    }

    public static void validateLength(TupleEntryIterator iterator, int numTuples, int tupleSize) {
        CascadingTestCase.validateLength(iterator, numTuples, tupleSize, null);
    }

    public static void validateLength(TupleEntryIterator iterator, int numTuples, Pattern regex) {
        CascadingTestCase.validateLength(iterator, numTuples, -1, regex);
    }

    public static void validateLength(TupleEntryIterator iterator, int numTuples, int tupleSize, Pattern regex) {
        Consumer<Integer> wrongNumberOfLines = c -> CascadingTestCase.assertEquals((String)"wrong number of lines", (int)numTuples, (int)c);
        Consumer<Integer> wrongNumberOfElements = tupleSize != -1 ? t -> CascadingTestCase.assertEquals((String)"wrong number of elements", (int)tupleSize, (int)t) : t -> {};
        Consumer<Tuple> verifyTuple = regex != null ? t -> CascadingTestCase.assertTrue((String)("regex: " + regex + " does not match: " + t.toString()), (boolean)regex.matcher(t.toString()).matches()) : t -> {};
        CascadingTesting.validateEntries(iterator, wrongNumberOfLines, wrongNumberOfElements, verifyTuple);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple arguments, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, new TupleEntry(arguments), resultFields);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple arguments, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeFunction(function, new TupleEntry(arguments), resultFields, properties);
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry arguments, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, arguments, resultFields, new HashMap<Object, Object>());
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry arguments, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeFunction(function, arguments, resultFields, properties);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeFunction(function, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, argumentsArray, resultFields, new HashMap<Object, Object>());
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeFunction(function, argumentsArray, resultFields, properties);
    }

    public static boolean invokeFilter(Filter filter, Tuple arguments) {
        return CascadingTesting.invokeFilter(filter, new TupleEntry(arguments));
    }

    public static boolean invokeFilter(Filter filter, Tuple arguments, Map<Object, Object> properties) {
        return CascadingTesting.invokeFilter(filter, new TupleEntry(arguments), properties);
    }

    public static boolean invokeFilter(Filter filter, TupleEntry arguments) {
        return CascadingTesting.invokeFilter(filter, arguments, new HashMap<Object, Object>());
    }

    public static boolean invokeFilter(Filter filter, TupleEntry arguments, Map<Object, Object> properties) {
        return CascadingTesting.invokeFilter(filter, arguments, properties);
    }

    public static boolean[] invokeFilter(Filter filter, Tuple[] argumentsArray) {
        return CascadingTesting.invokeFilter(filter, argumentsArray);
    }

    public static boolean[] invokeFilter(Filter filter, Tuple[] argumentsArray, Map<Object, Object> properties) {
        return CascadingTesting.invokeFilter(filter, argumentsArray, properties);
    }

    public static boolean[] invokeFilter(Filter filter, TupleEntry[] argumentsArray) {
        return CascadingTesting.invokeFilter(filter, argumentsArray, Collections.emptyMap());
    }

    public static boolean[] invokeFilter(Filter filter, TupleEntry[] argumentsArray, Map<Object, Object> properties) {
        return CascadingTesting.invokeFilter(filter, argumentsArray, properties);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, Tuple[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeAggregator(aggregator, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeAggregator(aggregator, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeAggregator(aggregator, null, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeAggregator(aggregator, null, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeAggregator(aggregator, group, argumentsArray, resultFields, Collections.emptyMap());
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeAggregator(aggregator, group, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, Tuple[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeBuffer(buffer, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeBuffer(buffer, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeBuffer(buffer, null, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeBuffer(buffer, null, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeBuffer(buffer, group, argumentsArray, resultFields, Collections.emptyMap());
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeBuffer(buffer, group, argumentsArray, resultFields, properties);
    }

    public static List<Tuple> getSourceAsList(Flow flow) throws IOException {
        return CascadingTesting.getSourceAsList(flow);
    }

    public static List<Tuple> getSinkAsList(Flow flow) throws IOException {
        return CascadingTesting.getSinkAsList(flow);
    }

    public static List<Tuple> asList(Flow flow, Tap tap) throws IOException {
        return CascadingTesting.asList(flow, tap);
    }

    public static List<Tuple> asList(Flow flow, Tap tap, Fields selector) throws IOException {
        return CascadingTesting.asList(flow, tap, selector);
    }

    public static Set<Tuple> asSet(Flow flow, Tap tap) throws IOException {
        return CascadingTesting.asSet(flow, tap);
    }

    public static Set<Tuple> asSet(Flow flow, Tap tap, Fields selector) throws IOException {
        return CascadingTesting.asSet(flow, tap, selector);
    }

    public static <C extends Collection<Tuple>> C asCollection(Flow flow, Tap tap, C collection) throws IOException {
        return CascadingTesting.asCollection(flow, tap, Fields.ALL, collection);
    }

    public static <C extends Collection<Tuple>> C asCollection(Flow flow, Tap tap, Fields selector, C collection) throws IOException {
        return CascadingTesting.asCollection(flow, tap, selector, collection);
    }

    public static <C extends Collection<Tuple>> C asCollection(TupleEntryIterator iterator, C result) {
        return CascadingTesting.asCollection(iterator, Fields.ALL, result);
    }

    public static <C extends Collection<Tuple>> C asCollection(TupleEntryIterator iterator, Fields selector, C result) {
        return CascadingTesting.asCollection(iterator, selector, result);
    }

    static class TestFlowProcess
    extends FlowProcess.NullFlowProcess {
        private final Map<Object, Object> properties;

        public TestFlowProcess(Map<Object, Object> properties) {
            this.properties = properties;
        }

        public Object getProperty(String key) {
            return this.properties.get(key);
        }
    }
}

