/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.CascadingTestCase;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.TupleViews;
import org.junit.Test;

public class TupleViewTest
extends CascadingTestCase {
    @Test
    public void testArgumentSelector() {
        Fields declarator = new Fields(new Comparable[]{"1", "2", "3", "4"});
        Tuple incoming = new Tuple(new Object[]{1, 2, 3, 4});
        Fields selector = new Fields(new Comparable[]{"3", "2"});
        this.assertTuple(incoming.get(declarator, selector));
        int[] pos = incoming.getPos(declarator, selector);
        this.assertTuple(incoming.get(pos));
        this.assertTuple(TupleViews.createNarrow((int[])pos, (Tuple)incoming));
    }

    private void assertTuple(Tuple result) {
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{3, 2}), (Object)result);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{3, 2}), (Object)new Tuple(result));
        TupleViewTest.assertEquals((Object)3, (Object)result.getObject(0));
        TupleViewTest.assertEquals((Object)2, (Object)result.getObject(1));
    }

    @Test
    public void testSelectorAll() {
        Fields incomingFields = new Fields(new Comparable[]{"1", "2", "3", "4"});
        Tuple incoming = new Tuple(new Object[]{1, 2, 3, 4});
        Fields resultFields = new Fields(new Comparable[]{"5", "6", "7"});
        Tuple result = new Tuple(new Object[]{5, 6, 7});
        Tuple view = TupleViews.createComposite((Tuple[])new Tuple[]{incoming, result});
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 2, 3, 4, 5, 6, 7}), (Object)view);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 2, 3, 4, 5, 6, 7}), (Object)new Tuple(view));
        Fields allFields = Fields.join((Fields[])new Fields[]{incomingFields, resultFields});
        Fields selector = new Fields(new Comparable[]{"3", "2"});
        this.assertTuple(view.get(allFields, selector));
    }

    @Test
    public void testSelectorReplace() {
        Fields incomingFields = new Fields(new Comparable[]{"1", "2", "3", "4"});
        Tuple incoming = new Tuple(new Object[]{1, 2, 3, 4});
        Fields resultFields = new Fields(new Comparable[]{"3", "2"});
        Tuple result = new Tuple(new Object[]{5, 6});
        int[] setPos = incomingFields.getPos(resultFields);
        Tuple view = TupleViews.createOverride((int[])incomingFields.getPos(), (Tuple)incoming, (int[])setPos, (Tuple)result);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 6, 5, 4}), (Object)view);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 6, 5, 4}), (Object)new Tuple(view));
    }

    @Test
    public void testSelectorMixed() {
        Fields incomingFields = new Fields(new Comparable[]{"1", "2", "3", "4"});
        Tuple incoming = new Tuple(new Object[]{1, 2, 3, 4});
        Fields resultFields = new Fields(new Comparable[]{"5", "6", "7"});
        Tuple result = new Tuple(new Object[]{5, 6, 7});
        Tuple bottomView = TupleViews.createComposite((Tuple[])new Tuple[]{incoming, result});
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 2, 3, 4, 5, 6, 7}), (Object)bottomView);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 2, 3, 4, 5, 6, 7}), (Object)new Tuple(bottomView));
        Fields allFields = Fields.join((Fields[])new Fields[]{incomingFields, resultFields});
        Fields selector = new Fields(new Comparable[]{"3", "2"});
        Tuple view = TupleViews.createNarrow((int[])allFields.getPos(selector), (Tuple)bottomView);
        this.assertTuple(view);
    }

    @Test
    public void testSelectorSwap() {
        Fields incomingFields = new Fields(new Comparable[]{"1", "2", "3", "4"});
        Tuple incoming = new Tuple(new Object[]{1, 2, 3, 4});
        Fields remainderFields = new Fields(new Comparable[]{"1", "4"});
        Tuple bottomView = TupleViews.createNarrow((int[])incomingFields.getPos(remainderFields), (Tuple)incoming);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4}), (Object)bottomView);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4}), (Object)new Tuple(bottomView));
        Fields resultFields = new Fields(new Comparable[]{"5", "6", "7"});
        Tuple result = new Tuple(new Object[]{5, 6, 7});
        Tuple view = TupleViews.createComposite((Tuple[])new Tuple[]{bottomView, result});
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4, 5, 6, 7}), (Object)view);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4, 5, 6, 7}), (Object)new Tuple(view));
        Tuple fieldView = TupleViews.createComposite((Fields[])new Fields[]{remainderFields, resultFields});
        TupleViews.reset((Tuple)fieldView, (Object[])new Tuple[]{view, result});
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4, 5, 6, 7}), (Object)fieldView);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{1, 4, 5, 6, 7}), (Object)new Tuple(fieldView));
    }

    @Test
    public void testSelectorSwap2() {
        Fields incomingFields = new Fields(new Comparable[]{"0", "1", Integer.valueOf(2), Integer.valueOf(3)});
        Tuple incoming = new Tuple(new Object[]{0, 1, 2, 3});
        Fields resultFields = new Fields(new Comparable[]{"0", "1"});
        Tuple result = new Tuple(new Object[]{0, 1});
        Fields remainderFields = incomingFields.subtract(resultFields);
        Tuple remainderView = TupleViews.createNarrow((int[])incomingFields.getPos(remainderFields));
        Tuple outgoingTuple = TupleViews.createComposite((Fields[])new Fields[]{Fields.asDeclaration((Fields)remainderFields), resultFields});
        TupleViews.reset((Tuple)remainderView, (Object[])new Tuple[]{incoming});
        TupleViews.reset((Tuple)outgoingTuple, (Object[])new Tuple[]{remainderView, result});
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{2, 3, 0, 1}), (Object)outgoingTuple);
        TupleViewTest.assertEquals((Object)new Tuple(new Object[]{2, 3, 0, 1}), (Object)new Tuple(outgoingTuple));
    }
}

