/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryChainIterator;
import cascading.tuple.TupleEntryCollector;
import java.util.Iterator;
import java.util.LinkedList;

public class TupleListCollector
extends TupleEntryCollector
implements Iterable<Tuple> {
    private final LinkedList<Tuple> tuples = new LinkedList();
    private boolean copyTupleOnCollect = false;

    public TupleListCollector(Fields fields, Tuple ... tuple) {
        super(fields);
        this.collect(tuple);
    }

    public TupleListCollector(Fields fields, boolean copyTupleOnCollect) {
        super(fields);
        this.copyTupleOnCollect = copyTupleOnCollect;
    }

    private void collect(Tuple ... tuples) {
        for (Tuple tuple : tuples) {
            this.add(tuple);
        }
    }

    protected void collect(TupleEntry tupleEntry) {
        if (this.copyTupleOnCollect) {
            this.tuples.add(tupleEntry.getTupleCopy());
        } else {
            this.tuples.add(tupleEntry.getTuple());
        }
    }

    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public void clear() {
        this.tuples.clear();
    }

    public int size() {
        return this.tuples.size();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.tuples.iterator();
    }

    public Iterator<TupleEntry> entryIterator() {
        return new TupleEntryChainIterator(this.tupleEntry.getFields(), this.tuples.iterator());
    }
}

