/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.CascadingTestCase;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import org.junit.Test;

public class TupleFieldsTest
extends CascadingTestCase {
    private Fields fields;
    private Tuple tuple;

    @Override
    public void setUp() throws Exception {
        this.tuple = new Tuple();
        this.tuple.add((Comparable)((Object)"a"));
        this.tuple.add((Comparable)((Object)"b"));
        this.tuple.add((Comparable)((Object)"c"));
        this.tuple.add((Comparable)((Object)"d"));
        this.tuple.add((Comparable)((Object)"d"));
        this.fields = new Fields(new Comparable[]{"one", "two", "three", "four", "five"});
    }

    @Test
    public void testHas() {
        TupleFieldsTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"one"})).getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"two"})).getObject(0));
    }

    @Test
    public void testGet() {
        Fields aFields = new Fields(new Comparable[]{"one"});
        Tuple aTuple = this.tuple.get(this.fields, aFields);
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.size()", (int)1, (int)aTuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.getObject(1));
    }

    @Test
    public void testWildcard() {
        Fields aFields = Fields.ALL;
        Tuple aTuple = this.tuple.get(this.fields, aFields);
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.size()", (int)5, (int)aTuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.get(this.fields, new Fields(new Comparable[]{"one"})).getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.get( 1 )", (Object)"b", (Object)aTuple.get(this.fields, new Fields(new Comparable[]{"two"})).getObject(0));
    }

    @Test
    public void testRemove() {
        Fields aFields = new Fields(new Comparable[]{"one"});
        Tuple aTuple = this.tuple.remove(this.fields, aFields);
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.size()", (int)1, (int)aTuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        this.fields = this.fields.subtract(aFields);
        TupleFieldsTest.assertEquals((String)"not equal: tuple.size()", (int)4, (int)this.tuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"b", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"two"})).getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"c", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"three"})).getObject(0));
    }

    @Test
    public void testPut() {
        Fields aFields = new Fields(new Comparable[]{"one", "five"});
        this.tuple.put(this.fields, aFields, new Tuple(new Object[]{"ten", "eleven"}));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"ten", (Object)this.tuple.getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"ten", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"one"})).getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"eleven", (Object)this.tuple.getObject(4));
        TupleFieldsTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"eleven", (Object)this.tuple.get(this.fields, new Fields(new Comparable[]{"five"})).getObject(0));
    }

    @Test
    public void testSelectComplex() {
        Tuple tuple = new Tuple(new Object[]{"movie", "name1", "movie1", "rate1", "name2", "movie2", "rate2"});
        Fields declarationA = new Fields(new Comparable[]{"movie", "name1", "movie1", "rate1", "name2", "movie2", "rate2"});
        Fields selectA = new Fields(new Comparable[]{"movie", "name1", "rate1", "name2", "rate2"});
        Tuple result = tuple.get(declarationA, selectA);
        TupleFieldsTest.assertEquals((String)"not equal: ", (int)5, (int)result.size());
        TupleFieldsTest.assertEquals((String)"not equal: ", (Object)"movie", (Object)result.getObject(0));
        TupleFieldsTest.assertEquals((String)"not equal: ", (Object)"name1", (Object)result.getObject(1));
        TupleFieldsTest.assertEquals((String)"not equal: ", (Object)"rate1", (Object)result.getObject(2));
        TupleFieldsTest.assertEquals((String)"not equal: ", (Object)"name2", (Object)result.getObject(3));
        TupleFieldsTest.assertEquals((String)"not equal: ", (Object)"rate2", (Object)result.getObject(4));
    }
}

