/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.CascadingTestCase;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.tuple.type.DateType;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Test;

public class TupleEntryTest
extends CascadingTestCase {
    @Test
    public void testSelect() {
        Fields selector = new Fields(new Comparable[]{"a", "d"});
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"}));
        TupleEntry entryB = new TupleEntry(new Fields(new Comparable[]{"c", "d"}), new Tuple(new Object[]{"c", "d"}));
        Tuple tuple = TupleEntry.select((Fields)selector, (TupleEntry[])new TupleEntry[]{entryA, entryB});
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"a", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"d", (Object)tuple.getObject(1));
    }

    @Test
    public void testSelect2() {
        Fields selector = new Fields(new Comparable[]{Integer.valueOf(1), "d"});
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"}));
        TupleEntry entryB = new TupleEntry(new Fields(new Comparable[]{"c", "d"}), new Tuple(new Object[]{"c", "d"}));
        Tuple tuple = TupleEntry.select((Fields)selector, (TupleEntry[])new TupleEntry[]{entryA, entryB});
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"b", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"d", (Object)tuple.getObject(1));
    }

    @Test
    public void testSelectNotComparable() {
        Fields selector = new Fields(new Comparable[]{Integer.valueOf(1), "d"});
        Object object = new Object();
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", object}));
        TupleEntry entryB = new TupleEntry(new Fields(new Comparable[]{"c", "d"}), new Tuple(new Object[]{"c", "d"}));
        Tuple tuple = TupleEntry.select((Fields)selector, (TupleEntry[])new TupleEntry[]{entryA, entryB});
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)object, (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"d", (Object)tuple.getObject(1));
    }

    @Test
    public void testSelectComplex() {
        Fields selector = new Fields(new Comparable[]{Integer.valueOf(-1), Integer.valueOf(-3)});
        Fields fieldsA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldsB = new Fields(new Comparable[]{"c", "d"});
        selector = Fields.resolve((Fields)selector, (Fields[])new Fields[]{fieldsA, fieldsB});
        TupleEntry entryA = new TupleEntry(fieldsA, new Tuple(new Object[]{"a", "b"}));
        TupleEntry entryB = new TupleEntry(fieldsB, new Tuple(new Object[]{"c", "d"}));
        Tuple tuple = TupleEntry.select((Fields)selector, (TupleEntry[])new TupleEntry[]{entryA, entryB});
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"d", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"b", (Object)tuple.getObject(1));
    }

    @Test
    public void testSelectComplex2() {
        Fields selector = new Fields(new Comparable[]{Integer.valueOf(-1), Integer.valueOf(-3)});
        Fields fieldsA = new Fields(new Comparable[]{"a", Integer.valueOf(1)});
        Fields fieldsB = new Fields(new Comparable[]{"c", Integer.valueOf(1)});
        selector = Fields.resolve((Fields)selector, (Fields[])new Fields[]{fieldsA, fieldsB});
        TupleEntry entryA = new TupleEntry(fieldsA, new Tuple(new Object[]{"a", "b"}));
        TupleEntry entryB = new TupleEntry(fieldsB, new Tuple(new Object[]{"c", "d"}));
        Tuple tuple = TupleEntry.select((Fields)selector, (TupleEntry[])new TupleEntry[]{entryA, entryB});
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"d", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"b", (Object)tuple.getObject(1));
    }

    @Test
    public void testExtractSet() {
        Fields selector = new Fields(new Comparable[]{Integer.valueOf(1), "d"});
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b", "c", "d"}), new Tuple(new Object[]{"a", "b", "c", "d"}));
        Tuple tuple = Tuples.extractTuple((TupleEntry)entryA, (Fields)selector);
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"b", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"d", (Object)tuple.getObject(1));
        entryA.setTuple(selector, new Tuple(new Object[]{"B", "D"}));
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"a", (Object)entryA.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"B", (Object)entryA.getObject(1));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(2)", (Object)"c", (Object)entryA.getObject(2));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(3)", (Object)"D", (Object)entryA.getObject(3));
    }

    @Test
    public void testExtractSet2() {
        Fields selector = new Fields(new Comparable[]{"d", Integer.valueOf(1)});
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b", "c", "d"}), new Tuple(new Object[]{"a", "b", "c", "d"}));
        Tuple tuple = Tuples.extractTuple((TupleEntry)entryA, (Fields)selector);
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"d", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"b", (Object)tuple.getObject(1));
        entryA.setTuple(selector, new Tuple(new Object[]{"D", "B"}));
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"a", (Object)entryA.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"B", (Object)entryA.getObject(1));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(2)", (Object)"c", (Object)entryA.getObject(2));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(3)", (Object)"D", (Object)entryA.getObject(3));
    }

    @Test
    public void testUnmodifiable() {
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b"}), true);
        Tuple tuple = new Tuple(new Object[]{"a", "b"});
        entryA.setTuple(tuple);
        TupleEntryTest.assertEquals((String)"wrong size", (int)2, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"a", (Object)tuple.getObject(0));
        try {
            entryA.setRaw((Comparable)((Object)"a"), (Object)"A");
            TupleEntryTest.fail((String)"did not fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            entryA.getTuple().set(0, (Object)"A");
            TupleEntryTest.fail((String)"did not fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        TupleEntryTest.assertEquals((Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"})), (Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"})));
        Fields fields = new Fields(new Comparable[]{"a", "b"});
        fields.setComparator((Comparable)((Object)"b"), (Comparator)new StringComparator());
        TupleEntryTest.assertEquals((Object)new TupleEntry(fields, new Tuple(new Object[]{"a", "b"})), (Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "B"})));
        TupleEntryTest.assertNotSame((Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "B"})), (Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"})));
        TupleEntryTest.assertNotSame((Object)new TupleEntry(new Fields(new Comparable[]{"a", "B"}), new Tuple(new Object[]{"a", "b"})), (Object)new TupleEntry(new Fields(new Comparable[]{"a", "b"}), new Tuple(new Object[]{"a", "b"})));
    }

    @Test
    public void testCoerceCanonical() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss:SSS Z");
        Date date = new Date();
        String stringDate = dateFormat.format(date);
        DateType coercible = new DateType("dd/MMM/yyyy:HH:mm:ss:SSS Z", TimeZone.getDefault());
        Fields fields = Fields.size((int)2).applyTypes(new Type[]{coercible, Long.TYPE});
        Tuple tuple = new Tuple(new Object[]{date.getTime(), date.getTime()});
        TupleEntry results = new TupleEntry(fields, tuple);
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(0));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((String)stringDate, (String)results.getString((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(1));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(1)));
        TupleEntryTest.assertEquals((String)Long.toString(date.getTime()), (String)results.getString((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testCoerceCanonicalUnknown() {
        Tuple tuple = new Tuple(new Object[]{1});
        TupleEntry results = new TupleEntry(Fields.UNKNOWN, tuple);
        TupleEntryTest.assertEquals((Object)1, (Object)results.getObject(0));
        TupleEntryTest.assertEquals((int)1, (int)results.getInteger((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((int)1, (int)results.getShort((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((long)1L, (long)results.getLong((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getFloat((Comparable)Integer.valueOf(0))));
        TupleEntryTest.assertEquals((Object)1.0, (Object)results.getDouble((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((String)"1", (String)results.getString((Comparable)Integer.valueOf(0)));
    }

    @Test(expected=TupleException.class)
    public void testCoerceCanonicalUnknownFail() {
        Tuple tuple = new Tuple(new Object[]{1});
        TupleEntry results = new TupleEntry(Fields.UNKNOWN, tuple);
        TupleEntryTest.assertEquals((int)1, (int)results.getInteger((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testCoerceOnSet() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss:SSS Z");
        Date date = new Date();
        String stringDate = dateFormat.format(date);
        DateType coercible = new DateType("dd/MMM/yyyy:HH:mm:ss:SSS Z", TimeZone.getDefault());
        Fields fields = Fields.size((int)5).applyTypes(new Type[]{coercible, coercible, coercible, coercible, Long.TYPE});
        Tuple tuple = Tuple.size((int)5);
        TupleEntry results = new TupleEntry(fields, tuple);
        results.setLong((Comparable)Integer.valueOf(0), date.getTime());
        results.setString((Comparable)Integer.valueOf(1), stringDate);
        results.setObject((Comparable)Integer.valueOf(2), (Object)date);
        results.setRaw(3, (Object)date);
        results.setString((Comparable)Integer.valueOf(4), Long.toString(date.getTime()));
        TupleEntryTest.assertTrue((boolean)(results.getObject(0) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(1) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(2) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(3) instanceof Date));
        TupleEntryTest.assertTrue((boolean)(results.getObject(4) instanceof Long));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(0));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((String)stringDate, (String)results.getString((Comparable)Integer.valueOf(0)));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(1));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(1)));
        TupleEntryTest.assertEquals((String)stringDate, (String)results.getString((Comparable)Integer.valueOf(1)));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(2));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(2)));
        TupleEntryTest.assertEquals((String)stringDate, (String)results.getString((Comparable)Integer.valueOf(2)));
        TupleEntryTest.assertEquals((Object)date, (Object)results.getObject(3));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(4));
        TupleEntryTest.assertEquals((long)date.getTime(), (long)results.getLong((Comparable)Integer.valueOf(4)));
        TupleEntryTest.assertEquals((int)((int)date.getTime()), (int)results.getInteger((Comparable)Integer.valueOf(4)));
        TupleEntryTest.assertEquals((String)Long.toString(date.getTime()), (String)results.getString((Comparable)Integer.valueOf(4)));
        results.setTuple(Tuple.size((int)5));
        Tuple expected = Tuple.size((int)5);
        expected.setLong(0, date.getTime());
        expected.setString(1, stringDate);
        expected.set(2, (Object)date);
        expected.set(3, (Object)date);
        expected.setString(4, Long.toString(date.getTime()));
        results.setCanonicalTuple(expected);
        TupleEntryTest.assertTrue((boolean)(results.getObject(0) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(1) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(2) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(3) instanceof Long));
        TupleEntryTest.assertTrue((boolean)(results.getObject(4) instanceof Long));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(0));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(1));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(2));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(3));
        TupleEntryTest.assertEquals((Object)date.getTime(), (Object)results.getObject(4));
    }

    @Test
    public void testCoerceIterable() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss:SSS Z");
        DateType coercible = new DateType("dd/MMM/yyyy:HH:mm:ss:SSS Z", TimeZone.getDefault());
        Date date = new Date();
        String stringDate = dateFormat.format(date);
        Tuple tuple = Tuple.size((int)4);
        Fields fields = Fields.size((int)4).applyTypes(new Type[]{coercible, coercible, coercible, String.class});
        TupleEntry results = new TupleEntry(fields, tuple);
        results.setObject((Comparable)Integer.valueOf(0), (Object)date);
        results.setLong((Comparable)Integer.valueOf(1), date.getTime());
        results.setString((Comparable)Integer.valueOf(2), stringDate);
        results.setString((Comparable)Integer.valueOf(3), stringDate);
        Iterable iterable = results.asIterableOf(String.class);
        int count = 0;
        for (String s : iterable) {
            TupleEntryTest.assertEquals((String)stringDate, (String)s);
            ++count;
        }
        TupleEntryTest.assertEquals((int)count, (int)results.size());
    }

    @Test
    public void testPairwiseIterable() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss:SSS Z");
        DateType coercible = new DateType("dd/MMM/yyyy:HH:mm:ss:SSS Z", TimeZone.getDefault());
        Date date = new Date();
        String stringDate = dateFormat.format(date);
        Tuple tuple = Tuple.size((int)4);
        Fields fields = Fields.size((int)4).applyTypes(new Type[]{coercible, coercible, coercible, String.class});
        TupleEntry results = new TupleEntry(fields, tuple);
        results.setObject((Comparable)Integer.valueOf(0), (Object)date);
        results.setLong((Comparable)Integer.valueOf(1), date.getTime());
        results.setString((Comparable)Integer.valueOf(2), stringDate);
        results.setString((Comparable)Integer.valueOf(3), stringDate);
        Iterable iterable = results.asPairwiseIterable();
        int count = 0;
        for (String[] pair : iterable) {
            TupleEntryTest.assertEquals((String)String.valueOf(count), (String)pair[0]);
            TupleEntryTest.assertEquals((String)stringDate, (String)pair[1]);
            ++count;
        }
        TupleEntryTest.assertEquals((int)count, (int)results.size());
    }

    @Test
    public void testSet() {
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b", "c"}), new Tuple(new Object[]{"a", "b", "c"}));
        TupleEntry entryB = new TupleEntry(new Fields(new Comparable[]{"c", "b"}), new Tuple(new Object[]{"C", "B"}));
        entryA.set(entryB);
        Tuple tuple = entryA.getTuple();
        TupleEntryTest.assertEquals((String)"wrong size", (int)3, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"a", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"B", (Object)tuple.getObject(1));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(2)", (Object)"C", (Object)tuple.getObject(2));
    }

    @Test
    public void testSetNull() {
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b", "c"}), new Tuple(new Object[]{"a", "b", "c"}));
        entryA.setTuple(null);
        TupleEntryTest.assertTrue((entryA.getTuple() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSetCanonicalNull() {
        TupleEntry entryA = new TupleEntry(new Fields(new Comparable[]{"a", "b", "c"}), new Tuple(new Object[]{"a", "b", "c"}));
        entryA.setCanonicalTuple(null);
        TupleEntryTest.assertTrue((entryA.getTuple() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSetCoerce() {
        Fields fieldsA = new Fields(new Comparable[]{"a", "b", "c"}).applyTypes(new Type[]{String.class, String.class, String.class});
        TupleEntry entryA = new TupleEntry(fieldsA, new Tuple(new Object[]{"0", "1", "2"}));
        Fields fieldsB = new Fields(new Comparable[]{"c", "b"}).applyTypes(new Type[]{Integer.class, Integer.class});
        TupleEntry entryB = new TupleEntry(fieldsB, new Tuple(new Object[]{-2, -1}));
        entryA.set(entryB);
        Tuple tuple = entryA.getTuple();
        TupleEntryTest.assertEquals((String)"wrong size", (int)3, (int)tuple.size());
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"0", (Object)tuple.getObject(0));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"-1", (Object)tuple.getObject(1));
        TupleEntryTest.assertEquals((String)"not equal: tuple.get(2)", (Object)"-2", (Object)tuple.getObject(2));
    }

    private static class StringComparator
    implements Comparator<String>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            return lhs.compareToIgnoreCase(rhs);
        }
    }
}

