/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.CascadingTestCase;
import cascading.tuple.Fields;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.junit.Test;

public class FieldsTest
extends CascadingTestCase {
    @Test
    public void testDuplicate() {
        try {
            new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(0)});
            FieldsTest.fail((String)"accepted dupe field names");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new Fields(new Comparable[]{"foo", "foo"});
            FieldsTest.fail((String)"accepted dupe field names");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAppend() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0)});
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)appended.get(2));
    }

    @Test
    public void testAppend2() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(2)});
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)appended.get(2));
    }

    @Test
    public void testAppend3() {
        Fields fieldA = Fields.NONE;
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(2)});
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)appended.get(0));
    }

    @Test
    public void testAppend4() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(-1)});
        Fields appended = fieldA.appendSelector(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)-1, (Object)appended.get(2));
    }

    @Test
    public void testAppend4Fail() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(-1)});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(-1)});
        try {
            Fields appended = fieldA.appendSelector(fieldB);
            FieldsTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAppendNamed() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields fieldB = new Fields(new Comparable[]{"a"});
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(2));
    }

    @Test
    public void testAppendNamed2() {
        Fields fieldA = new Fields(new Comparable[]{"a"});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)appended.get(2));
    }

    @Test
    public void testAppendSelectNamed() {
        Fields fieldA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields fieldB = new Fields(new Comparable[]{"a"});
        Fields appended = fieldA.appendSelector(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(2));
    }

    @Test
    public void testAppendSelectNamed2() {
        Fields fieldA = new Fields(new Comparable[]{"a"});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields appended = fieldA.appendSelector(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(2));
    }

    @Test
    public void testAppendSelectNamedFail() {
        Fields fieldA = new Fields(new Comparable[]{"a", Integer.valueOf(0)});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        try {
            Fields appended = fieldA.appendSelector(fieldB);
            FieldsTest.fail((String)"did not throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRename() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields from = new Fields(new Comparable[]{"a", "b"});
        Fields to = new Fields(new Comparable[]{"A", "B"});
        Fields renamed = fields.rename(from, to);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"A", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"B", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)renamed.get(3));
    }

    @Test
    public void testRename2() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields from = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields to = new Fields(new Comparable[]{"A", "B"});
        Fields renamed = fields.rename(from, to);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"A", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"B", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)renamed.get(3));
    }

    @Test
    public void testRename3() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields from = new Fields(new Comparable[]{"a", "b"});
        Fields to = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields renamed = fields.rename(from, to);
        FieldsTest.assertTrue((String)"not isOrdered", (boolean)renamed.isOrdered());
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)renamed.get(3));
    }

    @Test
    public void testRename4() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields from = new Fields(new Comparable[]{"a", "b"});
        Fields to = new Fields(new Comparable[]{Integer.valueOf(3), Integer.valueOf(4)});
        Fields renamed = fields.rename(from, to);
        FieldsTest.assertTrue((String)"isOrdered", (!renamed.isOrdered() ? 1 : 0) != 0);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)4, (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)renamed.get(3));
    }

    @Test
    public void testDiff() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{"a"});
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)diff.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)diff.get(0));
    }

    @Test
    public void testDiff2() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = Fields.NONE;
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)diff.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)diff.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)diff.get(1));
    }

    @Test
    public void testDiffSame() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{"b", "a"});
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)0, (int)diff.size());
    }

    @Test
    public void testDiffIndex() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0)});
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)diff.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)diff.get(0));
    }

    @Test
    public void testDiffIndex2() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(1)});
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)diff.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)diff.get(0));
    }

    @Test
    public void testDiff3() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(4)});
        try {
            Fields diff = fieldA.subtract(fieldB);
            FieldsTest.fail((String)"did not throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSelect() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{"a", "b"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
    }

    @Test
    public void testSelect2() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{"b", "a"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(1));
    }

    @Test
    public void testSelectPos() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)got.get(1));
    }

    @Test
    public void testSelectPos2() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)got.get(1));
    }

    @Test
    public void testSelectMixed() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
    }

    @Test
    public void testSelectMixed2() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(1));
    }

    @Test
    public void testSelectMixed3() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(3)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(3));
    }

    @Test
    public void testSelectMixed4() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(2), Integer.valueOf(3), "a", "b"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(3));
    }

    @Test
    public void testSelectMixedNeg() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-2), Integer.valueOf(-1)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
    }

    @Test
    public void testSelectMixedNeg2() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-1), Integer.valueOf(-2)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(1));
    }

    @Test
    public void testSelectMixedNeg3() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(-2), Integer.valueOf(-1)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(3));
    }

    @Test
    public void testSelectMixedNeg4() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-2), Integer.valueOf(-1), "a", "b"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(3));
    }

    @Test
    public void testSelectMixedNeg5() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-4), Integer.valueOf(-3), Integer.valueOf(-2), Integer.valueOf(-1)});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(3));
    }

    @Test
    public void testResolveIndexOnly() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields declarationB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(0)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)got.get(0));
    }

    @Test
    public void testResolveIndexOnly2() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields declarationB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)got.get(0));
    }

    @Test
    public void testResolveIndexOnly3() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields declarationB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(2)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(0));
    }

    @Test
    public void testResolveIndexOnly4() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields declarationB = new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(3)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(0));
    }

    @Test
    public void testResolveIndexAppended() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(0)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
    }

    @Test
    public void testResolveIndexAppended2() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(1)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
    }

    @Test
    public void testResolveIndexAppended3() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(2)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)got.get(0));
    }

    @Test
    public void testResolveIndexAppended4() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(3)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)got.get(0));
    }

    @Test
    public void testResolveAppended() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{"a"});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
    }

    @Test
    public void testResolveAppended2() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{"b"});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(0));
    }

    @Test
    public void testResolveAppended3() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{"c"});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)got.get(0));
    }

    @Test
    public void testResolveAppended4() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{"d"});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)got.get(0));
    }

    @Test
    public void testResolveAppended5() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = new Fields(new Comparable[]{"c", "d"});
        Fields selectA = new Fields(new Comparable[]{"a", "d"});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)got.get(1));
    }

    @Test
    public void testResolveAppendedComplex() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields declarationB = new Fields(new Comparable[]{"c", "d", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-4), Integer.valueOf(-3), Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)});
        Fields got = Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
        FieldsTest.assertEquals((String)"not equal: ", (int)8, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)-2, (Object)got.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)-1, (Object)got.get(3));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(4));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(5));
        FieldsTest.assertEquals((String)"not equal: ", (Object)2, (Object)got.get(6));
        FieldsTest.assertEquals((String)"not equal: ", (Object)3, (Object)got.get(7));
    }

    @Test
    public void testResolveAppendedFail() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", Integer.valueOf(2), Integer.valueOf(3)});
        Fields declarationB = new Fields(new Comparable[]{"c", "d", Integer.valueOf(2), Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-4), Integer.valueOf(-3), "a", Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)});
        try {
            Fields.resolve((Fields)selectA, (Fields[])new Fields[]{declarationA, declarationB});
            FieldsTest.fail((String)"did not throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSelectFail() {
        Fields declarationA = new Fields(new Comparable[]{Integer.valueOf(2), "a", "b", Integer.valueOf(3)});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(2), Integer.valueOf(3), "a", "b"});
        try {
            declarationA.select(selectA);
            FieldsTest.fail((String)"did not catch invalid field");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSelectWildcard() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields selectA = Fields.ALL;
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
    }

    @Test
    public void testSelectComplex() {
        Fields declarationA = new Fields(new Comparable[]{"movie", "name1", "movie1", "rate1", "name2", "movie2", "rate2"});
        Fields selectA = new Fields(new Comparable[]{"movie", "name1", "rate1", "name2", "rate2"});
        int[] got = declarationA.getPos(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)5, (int)got.length);
        FieldsTest.assertEquals((String)"not equal: ", (int)0, (int)got[0]);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got[1]);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)got[2]);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)got[3]);
        FieldsTest.assertEquals((String)"not equal: ", (int)6, (int)got[4]);
    }

    @Test
    public void testUnknown() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b"});
        Fields declarationB = Fields.UNKNOWN;
        this.doTestUnknown(declarationA, declarationB);
        this.doTestUnknown(declarationB, declarationA);
    }

    private void doTestUnknown(Fields declarationA, Fields declarationB) {
        Fields got = declarationA.append(declarationB);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)got.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)got.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (int)0, (int)got.getPos(new Fields(new Comparable[]{"a"}))[0]);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.getPos(new Fields(new Comparable[]{"b"}))[0]);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)got.getPos(new Fields(new Comparable[]{Integer.valueOf(3)}))[0]);
        try {
            got.getPos(new Fields(new Comparable[]{"c"}));
            FieldsTest.fail((String)"did not throw failure");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSelectNegative() {
        Fields declarationA = new Fields(new Comparable[]{"movie", "name1", "movie1", "rate1", "name2", "movie2", "rate2"});
        Fields selectA = new Fields(new Comparable[]{Integer.valueOf(-1)});
        int[] got = declarationA.getPos(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)got.length);
        FieldsTest.assertEquals((String)"not equal: ", (int)6, (int)got[0]);
        Fields selectB = new Fields(new Comparable[]{Integer.valueOf(-8)});
        try {
            got = declarationA.getPos(selectB);
            FieldsTest.fail((String)"did not throw failure");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testJoin() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{"c", "d"});
        Fields join = Fields.join((Fields[])new Fields[]{fieldA, fieldB});
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)join.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)join.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)join.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)join.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)join.get(3));
    }

    @Test
    public void testNestedFieldsFail() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{"c", "d"});
        try {
            new Fields(new Comparable[]{fieldA, fieldB});
            FieldsTest.fail((String)"did not throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullFieldsFail() {
        try {
            new Fields(new Comparable[]{"foo", Integer.valueOf(1), null});
            FieldsTest.fail((String)"did not throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMergeFields() {
        Fields fieldA = new Fields(new Comparable[]{"a", "b"});
        Fields fieldB = new Fields(new Comparable[]{"c", "d"});
        Fields join = Fields.merge((Fields[])new Fields[]{fieldA, fieldB});
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)join.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)join.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)join.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"c", (Object)join.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)join.get(3));
        fieldA = new Fields(new Comparable[]{"a", "b"});
        fieldB = new Fields(new Comparable[]{"a", "d"});
        join = Fields.merge((Fields[])new Fields[]{fieldA, fieldB});
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)join.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)join.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)join.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)join.get(2));
        fieldA = Fields.size((int)2);
        fieldB = new Fields(new Comparable[]{"a", "d"});
        join = Fields.merge((Fields[])new Fields[]{fieldA, fieldB});
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)join.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)join.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)join.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)join.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"d", (Object)join.get(3));
    }

    @Test
    public void testSelectFrom() {
        Fields declarationA = new Fields(new Comparable[]{"a", "b", "c", "d", "e", "f", "g"});
        Fields declarationB = new Fields(new Comparable[]{"A", "B", "C", "D", "E", "F", "G"});
        Fields selectA = new Fields(new Comparable[]{"b", "d", "f"});
        Fields fields = declarationA.selectPos(selectA);
        Fields results = declarationB.select(fields);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)results.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"B", (Object)results.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"D", (Object)results.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"F", (Object)results.get(2));
    }

    @Test
    public void testTypedAppendToNone() {
        Fields fieldA = Fields.NONE;
        Fields fieldB = new Fields(Fields.names((Comparable[])new Comparable[]{"a"}), Fields.types((Type[])new Type[]{String.class}));
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)appended.getType(0));
    }

    @Test
    public void testTypedAppendNamed() {
        Fields fieldA = new Fields(Fields.names((Comparable[])new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}), Fields.types((Type[])new Type[]{Integer.TYPE, Integer.TYPE}));
        Fields fieldB = new Fields(Fields.names((Comparable[])new Comparable[]{"a"}), Fields.types((Type[])new Type[]{String.class}));
        Fields appended = fieldA.append(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)3, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(2));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)appended.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)appended.getType(1));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)appended.getType(2));
    }

    @Test
    public void testTypedRename() {
        Fields fields = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b", "c", "d"}), Fields.types((Type[])new Type[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}));
        Fields from = new Fields(new Comparable[]{"a", "b"});
        Fields to = new Fields(Fields.names((Comparable[])new Comparable[]{"A", "B"}), Fields.types((Type[])new Type[]{String.class, String.class}));
        Fields renamed = fields.rename(from, to);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)renamed.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)renamed.getType(1));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)renamed.getType(2));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)renamed.getType(3));
    }

    @Test
    public void testTypedSelect() {
        Fields declarationA = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b"}), Fields.types((Type[])new Type[]{Integer.TYPE, String.class}));
        Fields selectA = new Fields(new Comparable[]{"a", "b"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)got.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)got.getType(1));
    }

    @Test
    public void testTypedSelect2() {
        Fields declarationA = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b"}), Fields.types((Type[])new Type[]{Integer.TYPE, String.class}));
        Fields selectA = new Fields(new Comparable[]{"b", "a"});
        Fields got = declarationA.select(selectA);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)got.size());
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)got.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)got.getType(1));
    }

    @Test
    public void testTypedDiff() {
        Fields fieldA = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b"}), Fields.types((Type[])new Type[]{Integer.TYPE, String.class}));
        Fields fieldB = new Fields(new Comparable[]{"a"});
        Fields diff = fieldA.subtract(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)1, (int)diff.size());
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)diff.getType(0));
    }

    @Test
    public void testTypedApply() {
        Fields fieldA = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b"}), Fields.types((Type[])new Type[]{Integer.TYPE, Integer.TYPE}));
        Fields fieldB = new Fields(Fields.names((Comparable[])new Comparable[]{"a"}), Fields.types((Type[])new Type[]{String.class}));
        Fields appended = fieldA.applyTypes(fieldB);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)appended.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)appended.getType(1));
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)fieldA.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)fieldA.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)fieldA.get(1));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)fieldA.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)fieldA.getType(1));
    }

    @Test
    public void testApplyType() {
        Fields fieldA = new Fields(Fields.names((Comparable[])new Comparable[]{"a", "b"}), Fields.types((Type[])new Type[]{Integer.TYPE, Integer.TYPE}));
        Fields newField = fieldA.applyType((Comparable)((Object)"a"), String.class);
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)newField.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)newField.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)newField.get(1));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)newField.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)newField.getType(1));
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)fieldA.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)fieldA.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)fieldA.get(1));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)fieldA.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)fieldA.getType(1));
    }

    @Test
    public void testFieldApply() {
        Fields fieldA = new Fields(new Type[]{String.class, Integer.TYPE});
        Fields appended = fieldA.applyFields(new Comparable[]{"a", "b"});
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"a", (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"b", (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)appended.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)appended.getType(1));
        appended = fieldA.applyFields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)});
        FieldsTest.assertEquals((String)"not equal: ", (int)2, (int)appended.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)0, (Object)appended.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)1, (Object)appended.get(1));
        FieldsTest.assertEquals((String)"not equal: ", String.class, (Object)appended.getType(0));
        FieldsTest.assertEquals((String)"not equal: ", Integer.TYPE, (Object)appended.getType(1));
    }

    @Test
    public void testMergeWithSelectors() {
        Fields f1 = new Fields(new Comparable[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        Fields f2 = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10)});
        Fields merged = Fields.merge((Fields[])new Fields[]{f1, f2});
        FieldsTest.assertEquals((int)20, (int)merged.size());
    }

    @Test
    public void testMergeWithSelectorsWithTypes() {
        Object[] types = new Type[10];
        Arrays.fill(types, Integer.TYPE);
        types[1] = Long.TYPE;
        Fields f1 = new Fields(new Comparable[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}).applyTypes((Type[])types);
        Fields f2 = new Fields(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10)}).applyTypes((Type[])types);
        Fields merged = Fields.merge((Fields[])new Fields[]{f1, f2});
        FieldsTest.assertEquals((int)20, (int)merged.size());
        FieldsTest.assertEquals((int)20, (int)merged.getTypes().length);
        FieldsTest.assertEquals(Long.TYPE, (Object)merged.getTypes()[1]);
        FieldsTest.assertEquals(Long.TYPE, (Object)merged.getTypes()[11]);
    }

    @Test
    public void testResolveWithTypes() {
        Fields selector = new Fields(new Comparable[]{"ip"});
        Fields[] fields = new Fields[]{new Fields(new Comparable[]{"ip"}).applyTypes(new Type[]{String.class}), new Fields(new Comparable[]{"offset", "line"}).applyTypes(new Type[]{String.class, String.class})};
        Fields resolved = Fields.resolve((Fields)selector, (Fields[])fields);
        FieldsTest.assertTrue((boolean)resolved.hasTypes());
    }

    @Test
    public void testConstructorWithNullComparableInArray() {
        try {
            new Fields(new Comparable[]{"a", null, "c"});
            FieldsTest.fail((String)"Fields constructor should have thrown an Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithNullComparable() {
        try {
            Object comparable = null;
            new Fields(new Comparable[]{comparable});
            FieldsTest.fail((String)"Fields constructor should have thrown an Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithNullTypes() {
        try {
            new Fields(new Comparable[]{"a", "b", "c"}, new Type[]{Integer.TYPE, null, String.class});
            FieldsTest.fail((String)"Fields constructor should have thrown an Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithNullType() {
        try {
            Type type = null;
            new Fields((Comparable)((Object)"a"), type);
            FieldsTest.fail((String)"Fields constructor should have thrown an Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameStringFunction() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields renamed = fields.renameString(String::toUpperCase);
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"A", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"B", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"C", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"D", (Object)renamed.get(3));
    }

    @Test
    public void testRenameFunction() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields renamed = fields.rename(n -> n.toString().toUpperCase());
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"A", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"B", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"C", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"D", (Object)renamed.get(3));
    }

    @Test
    public void testRenameBiFunction() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        Fields renamed = fields.rename((n, t) -> "prefix." + n.toString().toUpperCase());
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.A", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.B", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.C", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.D", (Object)renamed.get(3));
    }

    @Test
    public void testRenameBiFunctionWithTypes() {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c", "d"});
        fields = fields.applyTypes(new Type[]{String.class, String.class, String.class, String.class});
        Fields renamed = fields.rename((n, t) -> "prefix." + t.getTypeName() + n.toString().toUpperCase());
        FieldsTest.assertEquals((String)"not equal: ", (int)4, (int)renamed.size());
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.java.lang.StringA", (Object)renamed.get(0));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.java.lang.StringB", (Object)renamed.get(1));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.java.lang.StringC", (Object)renamed.get(2));
        FieldsTest.assertEquals((String)"not equal: ", (Object)"prefix.java.lang.StringD", (Object)renamed.get(3));
    }
}

