/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.CascadingTestCase;
import cascading.operation.ConcreteCall;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.filter.Sample;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import org.junit.Test;

public class SampleFilterTest
extends CascadingTestCase {
    private ConcreteCall operationCall;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.operationCall = new ConcreteCall();
    }

    private TupleEntry getEntry(Tuple tuple) {
        return new TupleEntry(Fields.size((int)tuple.size()), tuple);
    }

    @Test
    public void testSample() {
        for (double i = 0.0; i < 1.0; i += 0.01) {
            this.performSampleTest(i, 100000);
        }
    }

    private void performSampleTest(double sample, int values) {
        Sample filter = new Sample(sample);
        int count = 0;
        filter.prepare(null, (OperationCall)this.operationCall);
        this.operationCall.setArguments(this.getEntry(new Tuple(new Object[]{1})));
        for (int j = 0; j < values; ++j) {
            if (filter.isRemove(null, (FilterCall)this.operationCall)) continue;
            ++count;
        }
        String message = String.format("sample:%f values:%d", sample, values);
        SampleFilterTest.assertEquals((String)message, (double)sample, (double)((double)count / (double)values), (double)1.0);
    }
}

