/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.AssertionException;
import cascading.operation.ConcreteCall;
import cascading.operation.GroupAssertion;
import cascading.operation.GroupAssertionCall;
import cascading.operation.OperationCall;
import cascading.operation.assertion.AssertGroupSizeEquals;
import cascading.operation.assertion.AssertGroupSizeLessThan;
import cascading.operation.assertion.AssertGroupSizeMoreThan;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import org.junit.Test;

public class GroupAssertionsTest
extends CascadingTestCase {
    private TupleEntry getEntry(Tuple tuple) {
        return new TupleEntry(Fields.size((int)tuple.size()), tuple);
    }

    private void assertFail(GroupAssertion assertion, TupleEntry groupEntry, TupleEntry ... values) {
        ConcreteCall operationCall = new ConcreteCall();
        operationCall.setGroup(groupEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)operationCall);
        assertion.start(FlowProcess.NULL, (GroupAssertionCall)operationCall);
        for (TupleEntry value : values) {
            operationCall.setArguments(value);
            assertion.aggregate(FlowProcess.NULL, (GroupAssertionCall)operationCall);
        }
        try {
            operationCall.setArguments(null);
            assertion.doAssert(FlowProcess.NULL, (GroupAssertionCall)operationCall);
            GroupAssertionsTest.fail();
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
    }

    private void assertPass(GroupAssertion assertion, TupleEntry groupEntry, TupleEntry ... values) {
        ConcreteCall operationCall = new ConcreteCall();
        operationCall.setGroup(groupEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)operationCall);
        assertion.start(FlowProcess.NULL, (GroupAssertionCall)operationCall);
        for (TupleEntry value : values) {
            operationCall.setArguments(value);
            assertion.aggregate(FlowProcess.NULL, (GroupAssertionCall)operationCall);
        }
        operationCall.setArguments(null);
        assertion.doAssert(FlowProcess.NULL, (GroupAssertionCall)operationCall);
        assertion.cleanup(FlowProcess.NULL, (OperationCall)operationCall);
    }

    @Test
    public void testSizeEquals() {
        AssertGroupSizeEquals assertion = new AssertGroupSizeEquals(1L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})), new TupleEntry[0]);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertGroupSizeEquals("1", 1L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})), new TupleEntry[0]);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testSizeLessThan() {
        AssertGroupSizeLessThan assertion = new AssertGroupSizeLessThan(2L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertGroupSizeLessThan("1", 2L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testSizeMoreThan() {
        AssertGroupSizeMoreThan assertion = new AssertGroupSizeMoreThan(1L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
        assertion = new AssertGroupSizeMoreThan("1", 1L);
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{null})), this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})), this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})), this.getEntry(new Tuple(new Object[]{"0", null})));
        this.assertPass((GroupAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})), this.getEntry(new Tuple(new Object[]{"0", 1})));
    }
}

