/*
 * Decompiled with CFR 0.152.
 */
package cascading.management.annotation;

import cascading.management.annotation.URISanitizer;
import cascading.management.annotation.Visibility;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class URISanitizerTest {
    @After
    public void tearDown() {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "");
        System.setProperty("cascading.management.annotation.urisanitizer.failurepassthrough", "false");
    }

    @Test
    public void testNull() {
        URISanitizer sanitizer = new URISanitizer();
        Assert.assertNull((Object)sanitizer.apply(Visibility.PUBLIC, null));
    }

    @Test
    public void testSyntaxException() {
        URISanitizer sanitizer = new URISanitizer();
        String malformed = " http://example.com";
        Assert.assertEquals((Object)"", (Object)sanitizer.apply(Visibility.PUBLIC, (Object)malformed));
    }

    @Test
    public void testSyntaxExceptionPassThrough() {
        System.setProperty("cascading.management.annotation.urisanitizer.failurepassthrough", "true");
        URISanitizer sanitizer = new URISanitizer();
        String malformed = " http://example.com";
        Assert.assertEquals((Object)malformed, (Object)sanitizer.apply(Visibility.PUBLIC, (Object)malformed));
    }

    @Test
    public void testURIPublicSanitizationWithString() {
        String uri = "http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PUBLIC, (Object)uri);
        Assert.assertEquals((Object)"/docs/resource1.html", (Object)result);
    }

    @Test
    public void testURIProtectedSanitizationWithMixedCaseString() {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "user,paSSword");
        String uri = "http://www.example.com:8080/docs/resource1.html?User=foo&password=secret&action=do";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/docs/resource1.html?action=do&", (Object)result);
    }

    @Test
    public void testURIProtectedSanitizationWithString() {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "user,password");
        String uri = "http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/docs/resource1.html?action=do&", (Object)result);
    }

    @Test
    public void testURIPrivateSanitizationWithString() {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "user,password");
        String uri = "http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)uri);
        Assert.assertEquals((Object)"http://www.example.com:8080/docs/resource1.html?action=do&", (Object)result);
    }

    @Test
    public void testURIPrivateSanitizationNoScheme() {
        String uri = "data/stuff";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)uri);
        Assert.assertEquals((Object)uri, (Object)result);
    }

    @Test
    public void testURIPublicSanitizationWithURI() throws IllegalArgumentException {
        URI uri = URI.create("http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do");
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PUBLIC, (Object)uri);
        Assert.assertEquals((Object)"/docs/resource1.html", (Object)result);
    }

    @Test
    public void testURIProtectedSanitizationWithURI() throws URISyntaxException {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "user,password");
        URI uri = URI.create("http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do");
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/docs/resource1.html?action=do&", (Object)result);
    }

    @Test
    public void testURIPrivateSanitizationWithURI() throws URISyntaxException {
        System.setProperty("cascading.management.annotation.urisanitizer.parameternames", "user,password");
        URI uri = URI.create("http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do");
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)uri);
        Assert.assertEquals((Object)"http://www.example.com:8080/docs/resource1.html?action=do&", (Object)result);
    }

    @Test
    public void testHDFSPublic() {
        String uri = "hdfs://hadoop42.example.com:8020/some/dataset";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PUBLIC, (Object)uri);
        Assert.assertEquals((Object)"/some/dataset", (Object)result);
    }

    @Test
    public void testHDFSProtected() {
        String uri = "hdfs://hadoop42.example.com:8020/some/dataset";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/some/dataset", (Object)result);
    }

    @Test
    public void testHDFSPrivate() {
        String uri = "hdfs://hadoop42.example.com:8020/some/dataset/";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)uri);
        Assert.assertEquals((Object)uri, (Object)result);
    }

    @Test
    public void testS3NGlob() {
        String uri = "s3n://some-bucket/2014/12/2[5-9]/*";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/2014/12/2[5-9]/*", (Object)result);
    }

    @Test
    public void testOpaqueURI() {
        String uri = "memory:driven.agent.driven.spark.SkewExampleTest.testSubmit(SkewExampleTest.scala:36)";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)uri);
        Assert.assertEquals((Object)"memory:driven.agent.driven.spark.SkewExampleTest.testSubmit(SkewExampleTest.scala:36)", (Object)result);
        result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"memory:", (Object)result);
        result = sanitizer.apply(Visibility.PUBLIC, (Object)uri);
        Assert.assertEquals((Object)"memory:", (Object)result);
    }

    @Test
    public void testS3NGlob2() {
        String uri = "s3n://host/path/conversion_date={2015-12-23,2015-12-22}";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PROTECTED, (Object)uri);
        Assert.assertEquals((Object)"/path/conversion_date={2015-12-23,2015-12-22}", (Object)result);
    }

    @Test
    public void testRelativePathWindows() {
        String path = "..\\some\\directory";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)path);
        Assert.assertEquals((Object)"../some/directory", (Object)result);
    }

    @Test
    public void testAbsolutePathWindows() {
        String path = "c:\\some\\directory";
        URISanitizer sanitizer = new URISanitizer();
        String result = sanitizer.apply(Visibility.PRIVATE, (Object)path);
        Assert.assertEquals((Object)"c:///some/directory", (Object)result);
    }
}

