/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.iso;

import cascading.CascadingTestCase;
import cascading.flow.FlowElement;
import cascading.flow.iso.NonTap;
import cascading.flow.iso.expression.TestBoundarySelJoinCoGroupExpressionGraph;
import cascading.flow.iso.expression.TestCheckpointExpression;
import cascading.flow.iso.expression.TestConsecutiveTapsExpressionGraph;
import cascading.flow.iso.expression.TestGroupGroupExpression;
import cascading.flow.iso.expression.TestHashJoinBlockingHashJoinExpression;
import cascading.flow.iso.expression.TestHashJoinSameSourceExpression;
import cascading.flow.iso.expression.TestMalformedJoinExpressionGraph;
import cascading.flow.iso.expression.TestNoGroupTapExpressionGraph;
import cascading.flow.iso.graph.HashJoinMergeIntoHashJoinStreamedStreamedMergeGraph;
import cascading.flow.iso.graph.HashJoinSameSourceGraph;
import cascading.flow.iso.graph.HashJoinsIntoMerge;
import cascading.flow.iso.graph.JoinAroundJoinRightMostGraph;
import cascading.flow.iso.graph.JoinAroundJoinRightMostGraphSwapped;
import cascading.flow.iso.graph.LoneGroupAssertionGraph;
import cascading.flow.iso.graph.SelfCoGroupGraph;
import cascading.flow.iso.graph.StandardElementGraph;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.iso.assertion.Asserted;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.subgraph.iterator.ExpressionSubGraphIterator;
import cascading.flow.planner.iso.transformer.ContractedTransformer;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.iso.transformer.RemoveBranchGraphTransformer;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleAssert;
import cascading.flow.planner.rule.RuleExec;
import cascading.flow.planner.rule.RuleExpression;
import cascading.flow.planner.rule.RulePartitioner;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.RuleResult;
import cascading.flow.planner.rule.expression.BufferAfterEveryExpression;
import cascading.flow.planner.rule.expression.LoneGroupExpression;
import cascading.flow.planner.rule.expressiongraph.MultiTapGroupExpressionGraph;
import cascading.flow.planner.rule.expressiongraph.NoGroupTapExpressionGraph;
import cascading.flow.planner.rule.expressiongraph.TapGroupTapExpressionGraph;
import cascading.flow.planner.rule.partitioner.ExpressionRulePartitioner;
import cascading.flow.planner.rule.partitioner.UniquePathRulePartitioner;
import cascading.flow.planner.rule.partitioner.WholeGraphStepPartitioner;
import cascading.flow.planner.rule.transformer.IntermediateTapElementFactory;
import cascading.flow.planner.rule.transformer.RemoveNoOpPipeTransformer;
import cascading.flow.planner.rule.transformer.RuleInsertionTransformer;
import cascading.flow.planner.rule.util.TraceWriter;
import cascading.pipe.Pipe;
import org.junit.Test;

public class IsomorphismTest
extends CascadingTestCase {
    @Test
    public void testElementGraphs() {
        IsomorphismTest.assertEquals((int)5, (int)ElementGraphs.findAllGroups((ElementGraph)new StandardElementGraph()).size());
        IsomorphismTest.assertEquals((int)3, (int)ElementGraphs.findSources((ElementGraph)new StandardElementGraph()).size());
        IsomorphismTest.assertEquals((int)2, (int)ElementGraphs.findSinks((ElementGraph)new StandardElementGraph()).size());
    }

    @Test
    public void testRemoveBranch() {
        StandardElementGraph standardElementGraph = new StandardElementGraph();
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-before.dot");
        Pipe pipe = ElementGraphs.findFirstPipeNamed((ElementGraph)standardElementGraph, (String)"remove");
        int size = standardElementGraph.vertexSet().size();
        ElementGraphs.removeBranchContaining((ElementGraph)standardElementGraph, (FlowElement)pipe);
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-after.dot");
        IsomorphismTest.assertEquals((int)(size - 3), (int)standardElementGraph.vertexSet().size());
    }

    @Test
    public void testRemoveBetweenBranchInclusive() {
        StandardElementGraph standardElementGraph = new StandardElementGraph(true);
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-before.dot");
        Pipe before = ElementGraphs.findFirstPipeNamed((ElementGraph)standardElementGraph, (String)"before");
        Pipe after = ElementGraphs.findLastPipeNamed((ElementGraph)standardElementGraph, (String)"after");
        int size = standardElementGraph.vertexSet().size();
        ElementGraphs.removeBranchBetween((ElementGraph)standardElementGraph, (FlowElement)before, (FlowElement)after, (boolean)true);
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-after.dot");
        IsomorphismTest.assertEquals((int)(size - 7), (int)standardElementGraph.vertexSet().size());
    }

    @Test
    public void testRemoveBetweenBranchExclusive() {
        StandardElementGraph standardElementGraph = new StandardElementGraph(true);
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-before.dot");
        Pipe before = ElementGraphs.findFirstPipeNamed((ElementGraph)standardElementGraph, (String)"last*upper2");
        Pipe after = ElementGraphs.findFirstPipeNamed((ElementGraph)standardElementGraph, (String)"after*last");
        int size = standardElementGraph.vertexSet().size();
        ElementGraphs.removeBranchBetween((ElementGraph)standardElementGraph, (FlowElement)before, (FlowElement)after, (boolean)false);
        standardElementGraph.writeDOT(this.getPlanPath() + "/standard-after.dot");
        IsomorphismTest.assertEquals((int)(size - 7), (int)standardElementGraph.vertexSet().size());
    }

    @Test
    public void testSubGraphIterator() {
        RuleRegistry ruleRegistry = new RuleRegistry();
        ruleRegistry.addElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new NonTapFactory());
        PlannerContext plannerContext = new PlannerContext(ruleRegistry, null, null, null, true);
        ruleRegistry.addRule((Rule)new RuleInsertionTransformer(PlanPhase.PreResolveAssembly, (RuleExpression)new TestCheckpointExpression(), "cascading.registry.tap.intermediate"));
        RuleResult ruleResult = new RuleExec(new TraceWriter(), ruleRegistry).executeRulePhase(PlanPhase.PreResolveAssembly, plannerContext, new RuleResult((FlowElementGraph)new StandardElementGraph()));
        FlowElementGraph flowElementGraph = ruleResult.getAssemblyGraph();
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new PlannerContext(), (ExpressionGraph)new NoGroupTapExpressionGraph(), (ExpressionGraph)new TapGroupTapExpressionGraph(), (ElementGraph)flowElementGraph);
        while (iterator.hasNext()) {
            IsomorphismTest.assertNotNull((Object)iterator.next());
        }
    }

    @Test
    public void testSubGraphIterator2() {
        RuleRegistry ruleRegistry = new RuleRegistry();
        PlannerContext plannerContext = new PlannerContext(ruleRegistry);
        ruleRegistry.addRule((Rule)new RemoveNoOpPipeTransformer());
        HashJoinMergeIntoHashJoinStreamedStreamedMergeGraph elementGraph = new HashJoinMergeIntoHashJoinStreamedStreamedMergeGraph();
        RuleResult ruleResult = new RuleExec(new TraceWriter(), ruleRegistry).executeRulePhase(PlanPhase.PreResolveAssembly, plannerContext, new RuleResult((FlowElementGraph)elementGraph));
        FlowElementGraph flowElementGraph = ruleResult.getAssemblyGraph();
        flowElementGraph.writeDOT(this.getPlanPath() + "/mergejoin.dot");
        ContractedTransformer transformer = new ContractedTransformer((ExpressionGraph)new TestNoGroupTapExpressionGraph());
        Transformed transformed = transformer.transform(plannerContext, (ElementGraph)flowElementGraph);
        transformed.writeDOTs(this.getPlanPath() + "/transform/");
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new PlannerContext(), (ExpressionGraph)new TestNoGroupTapExpressionGraph(), (ExpressionGraph)new TestConsecutiveTapsExpressionGraph(), false, (ElementGraph)flowElementGraph);
        RemoveBranchGraphTransformer removeTransformer = new RemoveBranchGraphTransformer((ExpressionGraph)new TestMalformedJoinExpressionGraph());
        int count = 0;
        while (iterator.hasNext()) {
            ElementGraph next = (ElementGraph)iterator.next();
            IsomorphismTest.assertNotNull((Object)next);
            next.writeDOT(this.getPlanPath() + "/pipeline/" + count + "-graph.dot");
            Transformed result = removeTransformer.transform(next);
            result.getEndGraph().writeDOT(this.getPlanPath() + "/pipeline/" + count + "-cleaned-graph.dot");
            ++count;
        }
    }

    @Test
    public void testSubGraphIteratorSelfCoGroup() {
        RuleRegistry ruleRegistry = new RuleRegistry();
        ruleRegistry.setResolveElementsEnabled(false);
        ruleRegistry.addRule((Rule)new RemoveNoOpPipeTransformer());
        ruleRegistry.addRule((Rule)new WholeGraphStepPartitioner());
        ruleRegistry.addRule((Rule)new ExpressionRulePartitioner(PlanPhase.PartitionNodes, new RuleExpression((ExpressionGraph)new TestNoGroupTapExpressionGraph(), (ExpressionGraph)new MultiTapGroupExpressionGraph())));
        ruleRegistry.addRule((Rule)new UniquePathRulePartitioner(PlanPhase.PartitionNodes, RulePartitioner.PartitionSource.PartitionCurrent, new RuleExpression((ExpressionGraph)new TestNoGroupTapExpressionGraph(), (ExpressionGraph)new TestBoundarySelJoinCoGroupExpressionGraph())));
        SelfCoGroupGraph elementGraph = new SelfCoGroupGraph();
        RuleExec ruleExec = new RuleExec(new TraceWriter(null), ruleRegistry);
        PlannerContext plannerContext = new PlannerContext(ruleRegistry);
        RuleResult ruleResult = ruleExec.exec(plannerContext, (FlowElementGraph)elementGraph);
    }

    @Test
    public void testSubGraphIteratorHashJoinsIntoMerge() {
        this.runSubGraphIteratorRotate(new HashJoinsIntoMerge(), 2);
    }

    @Test
    public void testSubGraphIteratorMergeIntoJoin() {
        this.runSubGraphIteratorRotate(new HashJoinMergeIntoHashJoinStreamedStreamedMergeGraph(), 2);
    }

    private void runSubGraphIteratorRotate(FlowElementGraph elementGraph, int numSubGraphs) {
        int count;
        RuleRegistry ruleRegistry = new RuleRegistry();
        PlannerContext plannerContext = new PlannerContext(ruleRegistry);
        ruleRegistry.addRule((Rule)new RemoveNoOpPipeTransformer());
        RuleResult ruleResult = new RuleExec(new TraceWriter(), ruleRegistry).executeRulePhase(PlanPhase.PreResolveAssembly, plannerContext, new RuleResult(elementGraph));
        FlowElementGraph flowElementGraph = ruleResult.getAssemblyGraph();
        flowElementGraph.writeDOT(this.getPlanPath() + "/node.dot");
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new PlannerContext(), (ExpressionGraph)new TestNoGroupTapExpressionGraph(), (ExpressionGraph)new TestConsecutiveTapsExpressionGraph(), false, (ElementGraph)flowElementGraph);
        iterator.getContractedGraph().writeDOT(this.getPlanPath() + "/node-contracted.dot");
        for (count = 0; iterator.hasNext() && count < 10; ++count) {
            ElementGraph next = iterator.next();
            IsomorphismTest.assertNotNull((Object)next);
            next.writeDOT(this.getPlanPath() + "/pipeline/" + count + "-graph.dot");
        }
        IsomorphismTest.assertEquals((String)"wrong number of sub-graphs", (int)numSubGraphs, (int)count);
    }

    @Test
    public void testRuleEngine() {
        RuleRegistry ruleRegistry = new RuleRegistry();
        ruleRegistry.addElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new NonTapFactory());
        PlannerContext plannerContext = new PlannerContext(ruleRegistry, null, null, null, true);
        ruleRegistry.addRule((Rule)new RuleAssert(PlanPhase.PreResolveAssembly, (RuleExpression)new LoneGroupExpression(), "lone group assertion"));
        ruleRegistry.addRule((Rule)new RuleInsertionTransformer(PlanPhase.PreResolveAssembly, (RuleExpression)new TestGroupGroupExpression(), "cascading.registry.tap.intermediate"));
        try {
            new RuleExec(new TraceWriter(), ruleRegistry).executeRulePhase(PlanPhase.PreResolveAssembly, plannerContext, new RuleResult((FlowElementGraph)new LoneGroupAssertionGraph()));
            IsomorphismTest.fail();
        }
        catch (PlannerException plannerException) {
            // empty catch block
        }
        new RuleExec(new TraceWriter(), ruleRegistry).executeRulePhase(PlanPhase.PreResolveAssembly, plannerContext, new RuleResult((FlowElementGraph)new HashJoinSameSourceGraph()));
    }

    @Test
    public void testLoneGroupAssertion() {
        this.assertion(new LoneGroupAssertionGraph(), (RuleExpression)new LoneGroupExpression());
    }

    @Test
    public void testStandardIsoTransform() {
        this.transform((ElementGraph)new StandardElementGraph(), new TestGroupGroupExpression());
    }

    @Test
    public void testHashJoinSameSourceGraphTransform() {
        this.transform((ElementGraph)new HashJoinSameSourceGraph(), new TestHashJoinSameSourceExpression());
    }

    @Test
    public void testJoinAroundJoinRightMostGraphTransform() {
        this.transform((ElementGraph)new JoinAroundJoinRightMostGraph(), new TestHashJoinBlockingHashJoinExpression());
    }

    @Test
    public void testJoinAroundJoinRightMostGraphTransformUsingSameSourceRule() {
        this.transform((ElementGraph)new JoinAroundJoinRightMostGraph(), new TestHashJoinSameSourceExpression());
    }

    @Test
    public void testJoinAroundJoinRightMostGraphSwappedTransform() {
        this.transform((ElementGraph)new JoinAroundJoinRightMostGraphSwapped(), new TestHashJoinBlockingHashJoinExpression());
    }

    @Test
    public void testNoPipeExpressionTransform() {
        this.transform((ElementGraph)new JoinAroundJoinRightMostGraphSwapped(), (RuleExpression)new BufferAfterEveryExpression());
    }

    private Asserted assertion(FlowElementGraph flowElementGraph, RuleExpression ruleExpression) {
        RuleRegistry ruleRegistry = new RuleRegistry();
        ruleRegistry.addElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new NonTapFactory());
        PlannerContext plannerContext = new PlannerContext(ruleRegistry, null, null, null, true);
        Asserted asserted = new RuleAssert(PlanPhase.PreResolveAssembly, ruleExpression, "message").assertion(plannerContext, (ElementGraph)flowElementGraph);
        return asserted;
    }

    private ElementGraph transform(ElementGraph flowElementGraph, RuleExpression ruleExpression) {
        RuleRegistry ruleRegistry = new RuleRegistry();
        ruleRegistry.addElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new NonTapFactory());
        PlannerContext plannerContext = new PlannerContext(ruleRegistry, null, null, null, true);
        RuleInsertionTransformer ruleTempTapInsertionTransformer = new RuleInsertionTransformer(PlanPhase.PreResolveAssembly, ruleExpression, "cascading.registry.tap.intermediate");
        Transformed insertionTransformed = ruleTempTapInsertionTransformer.transform(plannerContext, flowElementGraph);
        insertionTransformed.writeDOTs(this.getPlanPath());
        return insertionTransformed.getEndGraph();
    }

    private static class NonTapFactory
    extends IntermediateTapElementFactory {
        private NonTapFactory() {
        }

        public FlowElement create(ElementGraph graph, FlowElement flowElement) {
            return new NonTap();
        }
    }
}

