/*
 * Decompiled with CFR 0.152.
 */
package cascading.assembly;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.util.Arrays;
import java.util.TreeSet;

public class SortElements
extends BaseOperation
implements Function {
    private final Fields[] fields;

    public SortElements(Fields ... fields) {
        super(Fields.ARGS);
        this.fields = fields;
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        TreeSet<Tuple> set = new TreeSet<Tuple>();
        TupleEntry input = functionCall.getArguments();
        for (Fields field : this.fields) {
            set.add(input.selectTuple(field));
        }
        int i = 0;
        Tuple inputCopy = new Tuple(input.getTuple());
        for (Tuple tuple : set) {
            inputCopy.put(input.getFields(), this.fields[i++], tuple);
        }
        functionCall.getOutputCollector().add(inputCopy);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortElements)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SortElements that = (SortElements)((Object)object);
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fields != null ? Arrays.hashCode(this.fields) : 0);
        return result;
    }
}

