/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.util.Util;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;

public class UtilTest {
    String[] results = new String[]{null, null, "www.example.com", "ip-172-31-11-27.us-west-2.compute.internal", "172.31.11.27", "www.example.com", "hadoop42.example.com", "hadoop42.example.com", "hadoop42.example.com", "hadoop42.example.com", "hadoop42.example.com", "hadoop42.example.com", "some-bucket"};
    String[] uris = new String[]{null, "", "www.example.com", "http://ip-172-31-11-27.us-west-2.compute.internal:20888/proxy/application_1451945425832_15086/", "http://172.31.11.27:20888/proxy/application_1451945425832_15086/", "http://www.example.com:8080/docs/resource1.html?user=foo&password=secret&action=do", "hdfs://hadoop42.example.com:8020/some/dataset", "hdfs://foor:bar@hadoop42.example.com:8020/some/dataset", "hdfs://foor:bar@hadoop42.example.com:8020/some/dataset#@foo/:baz", "hadoop42.example.com:8020/some/dataset", "foor:bar@hadoop42.example.com:8020/some/dataset", "foor:bar@hadoop42.example.com/some/dataset", "s3n://some-bucket/2014/12/2[5-9]/*"};

    @Test
    public void testParseJarPath() {
        String[] paths = new String[]{"name.jar", "foo/bar/name.jar", "/foo/bar/name.jar", "name-3.5.7.jar", "foo/bar/name-3.5.7.jar", "/foo/bar/name-3.5.7.jar", "name-20101201.jar", "foo/bar/name-20101201.jar", "/foo/bar/name-20101201.jar", "name-test-3.0.5.RELEASE.jar", "foo/bar/name-test-3.0.5.RELEASE.jar", "/foo/bar/name-test-3.0.5.RELEASE.jar", "name-test-2.0.0-wip-dev.jar", "foo/bar/name-test-2.0.0-wip-dev.jar", "/foo/bar/name-test-2.0.0-wip-dev.jar", "file:///C:\\foo\\bar\\name-test-2.0.0-wip-dev.jar"};
        String[] names = new String[]{"name", "name", "name", "name", "name", "name", "name", "name", "name", "name-test", "name-test", "name-test", "name-test", "name-test", "name-test", "name-test"};
        String[] versions = new String[]{null, null, null, "3.5.7", "3.5.7", "3.5.7", "20101201", "20101201", "20101201", "3.0.5.RELEASE", "3.0.5.RELEASE", "3.0.5.RELEASE", "2.0.0-wip-dev", "2.0.0-wip-dev", "2.0.0-wip-dev", "2.0.0-wip-dev"};
        for (int i = 0; i < paths.length; ++i) {
            Assert.assertEquals((String)paths[i], (String)names[i], (String)Util.findName((String)paths[i]));
            Assert.assertEquals((String)paths[i], (String)versions[i], (String)Util.findVersion((String)paths[i]));
        }
    }

    @Test
    public void testContainsWhiteSpace() {
        TestCase.assertFalse((boolean)Util.containsWhitespace((String)""));
        TestCase.assertFalse((boolean)Util.containsWhitespace((String)"aGoodTagMayLookLikeThis"));
        TestCase.assertTrue((boolean)Util.containsWhitespace((String)" aaa"));
        TestCase.assertTrue((boolean)Util.containsWhitespace((String)"aaa\t "));
        TestCase.assertTrue((boolean)Util.containsWhitespace((String)"\tabc\tdef\tghi\t"));
        TestCase.assertTrue((boolean)Util.containsWhitespace((String)"contains\tstuff\twe\rdon't\nwant\f"));
    }

    @Test
    public void testURIHostnameParser() throws Exception {
        for (int i = 0; i < this.results.length; ++i) {
            String result = this.results[i];
            String uri = this.uris[i];
            Assert.assertEquals((String)result, (String)Util.parseHostname((String)uri));
        }
    }
}

