/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Buffer;
import cascading.operation.BufferCall;
import cascading.operation.OperationCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.io.IOException;
import java.util.Iterator;

public class TestBuffer
extends BaseOperation<TupleEntryCollector>
implements Buffer<TupleEntryCollector> {
    private Tap path;
    private int expectedSize = -1;
    private boolean insertHeader;
    private boolean insertFooter;
    private Comparable value;
    private boolean flushCalled = false;

    public TestBuffer(Tap path, Fields fieldDeclaration, int expectedSize, boolean insertHeader, boolean insertFooter, String value) {
        super(fieldDeclaration);
        this.path = path;
        this.expectedSize = expectedSize;
        this.insertHeader = insertHeader;
        this.insertFooter = insertFooter;
        this.value = value;
    }

    public TestBuffer(Fields fieldDeclaration, int expectedSize, boolean insertHeader, boolean insertFooter, String value) {
        super(fieldDeclaration);
        this.expectedSize = expectedSize;
        this.insertHeader = insertHeader;
        this.insertFooter = insertFooter;
        this.value = value;
    }

    public TestBuffer(Fields fieldDeclaration, int expectedSize, boolean insertHeader, String value) {
        super(fieldDeclaration);
        this.expectedSize = expectedSize;
        this.insertHeader = insertHeader;
        this.value = value;
    }

    public TestBuffer(Fields fieldDeclaration, boolean insertHeader, String value) {
        super(fieldDeclaration);
        this.insertHeader = insertHeader;
        this.value = value;
    }

    public TestBuffer(Fields fieldDeclaration, Comparable value) {
        super(fieldDeclaration);
        this.value = value;
    }

    public TestBuffer(Fields fieldDeclaration) {
        super(fieldDeclaration);
    }

    public void prepare(FlowProcess flowProcess, OperationCall<TupleEntryCollector> operationCall) {
        if (this.path == null) {
            return;
        }
        try {
            operationCall.setContext((Object)flowProcess.openTapForWrite(this.path));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void cleanup(FlowProcess flowProcess, OperationCall<TupleEntryCollector> operationCall) {
        if (!this.flushCalled) {
            throw new RuntimeException("flush never called");
        }
        if (this.path == null) {
            return;
        }
        ((TupleEntryCollector)operationCall.getContext()).close();
    }

    public void operate(FlowProcess flowProcess, BufferCall<TupleEntryCollector> bufferCall) {
        if (bufferCall.getJoinerClosure() != null) {
            throw new IllegalStateException("joiner closure should be null");
        }
        if (this.insertHeader) {
            bufferCall.getOutputCollector().add(new Tuple(new Object[]{this.value}));
        }
        Iterator iterator = bufferCall.getArgumentsIterator();
        while (iterator.hasNext()) {
            TupleEntry arguments = (TupleEntry)iterator.next();
            if (this.expectedSize != -1 && arguments.size() != this.expectedSize) {
                throw new RuntimeException("arguments wrong size");
            }
            if (this.path != null) {
                ((TupleEntryCollector)bufferCall.getContext()).add(arguments);
            }
            if (this.value != null) {
                bufferCall.getOutputCollector().add(new Tuple(new Object[]{this.value}));
                continue;
            }
            bufferCall.getOutputCollector().add(arguments);
        }
        if (this.insertFooter) {
            bufferCall.getOutputCollector().add(new Tuple(new Object[]{this.value}));
        }
        iterator.hasNext();
    }

    public void flush(FlowProcess flowProcess, OperationCall<TupleEntryCollector> tupleEntryCollectorOperationCall) {
        this.flushCalled = true;
    }
}

