/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;

public class TestAggregator
extends BaseOperation
implements Aggregator {
    private static final long serialVersionUID = 1L;
    private Tuple[] value;
    private int duplicates = 1;
    private Fields groupFields;

    public TestAggregator(Fields fields, Tuple ... value) {
        super(fields);
        this.value = value;
    }

    public TestAggregator(Fields fields, Fields groupFields, Tuple ... value) {
        super(fields);
        this.groupFields = groupFields;
        this.value = value;
    }

    public TestAggregator(Fields fieldDeclaration, Tuple value, int duplicates) {
        super(fieldDeclaration);
        this.value = new Tuple[]{value};
        this.duplicates = duplicates;
    }

    public TestAggregator(Fields fieldDeclaration, Fields groupFields, Tuple value, int duplicates) {
        super(fieldDeclaration);
        this.groupFields = groupFields;
        this.value = new Tuple[]{value};
        this.duplicates = duplicates;
    }

    public void start(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
        if (this.groupFields == null) {
            return;
        }
        if (!this.groupFields.equals((Object)aggregatorCall.getGroup().getFields())) {
            throw new RuntimeException("fields do not match: " + this.groupFields.print() + " != " + aggregatorCall.getGroup().getFields().print());
        }
    }

    public void aggregate(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
    }

    public void complete(FlowProcess flowProcess, AggregatorCall aggregatorCall) {
        TupleEntry result = aggregatorCall.getDeclaredFields().isUnknown() ? new TupleEntry(Fields.size((int)this.value[0].size()), Tuple.size((int)this.value[0].size())) : new TupleEntry(aggregatorCall.getDeclaredFields(), Tuple.size((int)aggregatorCall.getDeclaredFields().size()));
        for (int i = 0; i < this.duplicates; ++i) {
            for (Tuple tuple : this.value) {
                try {
                    result.setCanonicalTuple(tuple);
                }
                catch (Exception exception) {
                    result.setCanonicalTuple(Tuple.size((int)this.value[0].size(), (Comparable)Integer.valueOf(-99)));
                }
                aggregatorCall.getOutputCollector().add(result);
            }
        }
    }
}

