/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.Buffer;
import cascading.operation.BufferCall;
import cascading.operation.ConcreteCall;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleListCollector;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CascadingTesting
implements Serializable {
    public static void validateEntries(TupleEntryIterator iterator, Consumer<Integer> verifyLength, Consumer<Integer> verifyTupleSize, Consumer<Tuple> verifyTuple) {
        int count = 0;
        while (iterator.hasNext()) {
            TupleEntry tupleEntry = (TupleEntry)iterator.next();
            verifyTupleSize.accept(tupleEntry.size());
            verifyTuple.accept(tupleEntry.getTuple());
            ++count;
        }
        try {
            iterator.close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        verifyLength.accept(count);
    }

    private CascadingTesting() {
    }

    public static TupleListCollector invokeFunction(Function function, Tuple arguments, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, new TupleEntry(arguments), resultFields);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple arguments, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeFunction(function, new TupleEntry(arguments), resultFields, properties);
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry arguments, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, arguments, resultFields, new HashMap<Object, Object>());
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry arguments, Fields resultFields, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(arguments.getFields(), function.getFieldDeclaration());
        TupleListCollector collector = new TupleListCollector(resultFields, true);
        operationCall.setArguments(arguments);
        operationCall.setOutputCollector((TupleEntryCollector)collector);
        function.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        function.operate((FlowProcess)flowProcess, (FunctionCall)operationCall);
        function.cleanup((FlowProcess)flowProcess, (OperationCall)operationCall);
        return collector;
    }

    public static TupleListCollector invokeFunction(Function function, Tuple[] argumentsArray, Fields resultFields) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeFunction(function, entries, resultFields);
    }

    public static TupleListCollector invokeFunction(Function function, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeFunction(function, entries, resultFields, properties);
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeFunction(function, argumentsArray, resultFields, new HashMap<Object, Object>());
    }

    public static TupleListCollector invokeFunction(Function function, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(argumentsArray[0].getFields(), function.getFieldDeclaration());
        TupleListCollector collector = new TupleListCollector(resultFields, true);
        function.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        operationCall.setOutputCollector((TupleEntryCollector)collector);
        for (TupleEntry arguments : argumentsArray) {
            operationCall.setArguments(arguments);
            function.operate((FlowProcess)flowProcess, (FunctionCall)operationCall);
        }
        function.flush((FlowProcess)flowProcess, (OperationCall)operationCall);
        function.cleanup((FlowProcess)flowProcess, (OperationCall)operationCall);
        return collector;
    }

    public static boolean invokeFilter(Filter filter, Tuple arguments) {
        return CascadingTesting.invokeFilter(filter, new TupleEntry(arguments));
    }

    public static boolean invokeFilter(Filter filter, Tuple arguments, Map<Object, Object> properties) {
        return CascadingTesting.invokeFilter(filter, new TupleEntry(arguments), properties);
    }

    public static boolean invokeFilter(Filter filter, TupleEntry arguments) {
        return CascadingTesting.invokeFilter(filter, arguments, new HashMap<Object, Object>());
    }

    public static boolean invokeFilter(Filter filter, TupleEntry arguments, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(arguments.getFields());
        operationCall.setArguments(arguments);
        filter.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        boolean isRemove = filter.isRemove((FlowProcess)flowProcess, (FilterCall)operationCall);
        filter.cleanup((FlowProcess)flowProcess, (OperationCall)operationCall);
        return isRemove;
    }

    public static boolean[] invokeFilter(Filter filter, Tuple[] argumentsArray) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeFilter(filter, entries, Collections.emptyMap());
    }

    public static boolean[] invokeFilter(Filter filter, Tuple[] argumentsArray, Map<Object, Object> properties) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeFilter(filter, entries, properties);
    }

    public static boolean[] invokeFilter(Filter filter, TupleEntry[] argumentsArray) {
        return CascadingTesting.invokeFilter(filter, argumentsArray, Collections.emptyMap());
    }

    public static boolean[] invokeFilter(Filter filter, TupleEntry[] argumentsArray, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(argumentsArray[0].getFields());
        filter.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        boolean[] results = new boolean[argumentsArray.length];
        for (int i = 0; i < argumentsArray.length; ++i) {
            operationCall.setArguments(argumentsArray[i]);
            results[i] = filter.isRemove((FlowProcess)flowProcess, (FilterCall)operationCall);
        }
        filter.flush((FlowProcess)flowProcess, (OperationCall)operationCall);
        filter.cleanup((FlowProcess)flowProcess, (OperationCall)operationCall);
        return results;
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, Tuple[] argumentsArray, Fields resultFields) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeAggregator(aggregator, entries, resultFields);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeAggregator(aggregator, entries, resultFields, properties);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeAggregator(aggregator, null, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeAggregator(aggregator, null, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeAggregator(aggregator, group, argumentsArray, resultFields, Collections.emptyMap());
    }

    public static TupleListCollector invokeAggregator(Aggregator aggregator, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(argumentsArray[0].getFields(), aggregator.getFieldDeclaration());
        operationCall.setGroup(group);
        aggregator.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        aggregator.start((FlowProcess)flowProcess, (AggregatorCall)operationCall);
        for (TupleEntry arguments : argumentsArray) {
            operationCall.setArguments(arguments);
            aggregator.aggregate((FlowProcess)flowProcess, (AggregatorCall)operationCall);
        }
        TupleListCollector collector = new TupleListCollector(resultFields, true);
        operationCall.setOutputCollector((TupleEntryCollector)collector);
        aggregator.complete((FlowProcess)flowProcess, (AggregatorCall)operationCall);
        aggregator.cleanup(null, (OperationCall)operationCall);
        return collector;
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, Tuple[] argumentsArray, Fields resultFields) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeBuffer(buffer, entries, resultFields);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, Tuple[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TupleEntry[] entries = CascadingTesting.makeArgumentsArray(argumentsArray);
        return CascadingTesting.invokeBuffer(buffer, entries, resultFields, properties);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeBuffer(buffer, null, argumentsArray, resultFields);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        return CascadingTesting.invokeBuffer(buffer, null, argumentsArray, resultFields, properties);
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields) {
        return CascadingTesting.invokeBuffer(buffer, group, argumentsArray, resultFields, Collections.emptyMap());
    }

    public static TupleListCollector invokeBuffer(Buffer buffer, TupleEntry group, TupleEntry[] argumentsArray, Fields resultFields, Map<Object, Object> properties) {
        TestFlowProcess flowProcess = new TestFlowProcess(properties);
        ConcreteCall operationCall = new ConcreteCall(argumentsArray[0].getFields(), buffer.getFieldDeclaration());
        operationCall.setGroup(group);
        buffer.prepare((FlowProcess)flowProcess, (OperationCall)operationCall);
        TupleListCollector collector = new TupleListCollector(resultFields, true);
        operationCall.setOutputCollector((TupleEntryCollector)collector);
        operationCall.setArgumentsIterator(Arrays.asList(argumentsArray).iterator());
        buffer.operate((FlowProcess)flowProcess, (BufferCall)operationCall);
        buffer.cleanup(null, (OperationCall)operationCall);
        return collector;
    }

    private static TupleEntry[] makeArgumentsArray(Tuple[] argumentsArray) {
        TupleEntry[] entries = new TupleEntry[argumentsArray.length];
        for (int i = 0; i < argumentsArray.length; ++i) {
            entries[i] = new TupleEntry(argumentsArray[i]);
        }
        return entries;
    }

    public static List<Tuple> getSourceAsList(Flow flow) throws IOException {
        return CascadingTesting.asCollection(flow, (Tap)flow.getSourcesCollection().iterator().next(), Fields.ALL, new ArrayList());
    }

    public static List<Tuple> getSinkAsList(Flow flow) throws IOException {
        return CascadingTesting.asCollection(flow, flow.getSink(), Fields.ALL, new ArrayList());
    }

    public static List<Tuple> asList(Flow flow, Tap tap) throws IOException {
        return CascadingTesting.asCollection(flow, tap, Fields.ALL, new ArrayList());
    }

    public static List<Tuple> asList(Flow flow, Tap tap, Fields selector) throws IOException {
        return CascadingTesting.asCollection(flow, tap, selector, new ArrayList());
    }

    public static Set<Tuple> asSet(Flow flow, Tap tap) throws IOException {
        return CascadingTesting.asCollection(flow, tap, Fields.ALL, new HashSet());
    }

    public static Set<Tuple> asSet(Flow flow, Tap tap, Fields selector) throws IOException {
        return CascadingTesting.asCollection(flow, tap, selector, new HashSet());
    }

    public static <C extends Collection<Tuple>> C asCollection(Flow flow, Tap tap, C collection) throws IOException {
        return CascadingTesting.asCollection(flow, tap, Fields.ALL, collection);
    }

    public static <C extends Collection<Tuple>> C asCollection(Flow flow, Tap tap, Fields selector, C collection) throws IOException {
        try (TupleEntryIterator iterator = flow.openTapForRead(tap);){
            C c = CascadingTesting.asCollection(iterator, selector, collection);
            return c;
        }
    }

    public static <C extends Collection<Tuple>> C asCollection(TupleEntryIterator iterator, C result) {
        while (iterator.hasNext()) {
            result.add((Tuple)((TupleEntry)iterator.next()).getTupleCopy());
        }
        return result;
    }

    public static <C extends Collection<Tuple>> C asCollection(TupleEntryIterator iterator, Fields selector, C result) {
        while (iterator.hasNext()) {
            result.add((Tuple)((TupleEntry)iterator.next()).selectTupleCopy(selector));
        }
        return result;
    }

    static class TestFlowProcess
    extends FlowProcess.NullFlowProcess {
        private final Map<Object, Object> properties;

        public TestFlowProcess(Map<Object, Object> properties) {
            this.properties = properties;
        }

        public Object getProperty(String key) {
            return this.properties.get(key);
        }
    }
}

