/*
 * Copyright (c) 2007-2022 The Cascading Authors. All Rights Reserved.
 *
 * Project and contact information: https://cascading.wensel.net/
 *
 * This file is part of the Cascading project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cascading.util.cache;

import cascading.flow.FlowProcess;
import cascading.provider.CascadingFactory;

/**
 * Base class for all CacheFactories for creating {@link CascadingCache} instances. Each sub-assembly using
 * the {@link CascadingCache} facilities has it's own sub-class of this factory so that different Caches
 * can be used for different parts of the same flow.
 * <p>
 * A {@link cascading.util.cache.CacheEvictionCallback} can be set and it will be given to each Cache instance created
 * by the factory. If none is set, the Factory will use {@link cascading.util.cache.CacheEvictionCallback#NULL}, which
 * is a no-op implementation of the {@link cascading.util.cache.CacheEvictionCallback} interface.
 */
public abstract class BaseCacheFactory<Key, Value, Config> implements CascadingFactory<Config, CascadingCache<Key, Value>>
  {
  /** default capacity for all caches. */
  public static final int DEFAULT_CAPACITY = 10000;

  @Override
  public void initialize( FlowProcess<? extends Config> flowProcess )
    {

    }

  @Override
  public abstract CascadingCache<Key, Value> create( FlowProcess<? extends Config> flowProcess );
  }
