/*
 * Copyright (c) 2007-2022 The Cascading Authors. All Rights Reserved.
 *
 * Project and contact information: https://cascading.wensel.net/
 *
 * This file is part of the Cascading project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cascading.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;

/**
 *
 */
public class NullSafeReverseComparator implements Comparator<Comparable<Object>>, Serializable
  {
  public static <T> Comparator<T> reverseOrder( Comparator<T> comparator )
    {
    if( comparator == null )
      return (Comparator<T>) new NullSafeReverseComparator();

    return Collections.reverseOrder( comparator );
    }

  @Override
  public int compare( Comparable<Object> lhs, Comparable<Object> rhs )
    {
    if( lhs == null && rhs == null )
      return 0;

    if( lhs == null )
      return 1;

    if( rhs == null )
      return -1;

    return rhs.compareTo( lhs );
    }
  }
