/*
 * Copyright (c) 2007-2022 The Cascading Authors. All Rights Reserved.
 *
 * Project and contact information: https://cascading.wensel.net/
 *
 * This file is part of the Cascading project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cascading.tuple.coerce;

import java.lang.reflect.Type;
import java.util.Map;

/**
 *
 */
public class ShortCoerce extends NumberCoerce<Short>
  {
  protected ShortCoerce( Map<Type, Coercions.Coerce> map )
    {
    super( map );
    }

  @Override
  public Class<Short> getCanonicalType()
    {
    return short.class;
    }

  @Override
  protected Short forNull()
    {
    return 0;
    }

  @Override
  protected Short forBoolean( Boolean f )
    {
    return f ? (short) 1 : (short) 0;
    }

  @Override
  protected <T> Short parseType( T f )
    {
    return Short.parseShort( f.toString() );
    }

  @Override
  protected Short asType( Number f )
    {
    return f.shortValue();
    }
  }
