/*
 * Copyright (c) 2007-2022 The Cascading Authors. All Rights Reserved.
 *
 * Project and contact information: https://cascading.wensel.net/
 *
 * This file is part of the Cascading project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cascading.flow.planner.rule.expressiongraph;

import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.iso.expression.AnnotationExpression;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.expression.FlowElementExpression;
import cascading.flow.stream.annotations.RoleMode;
import cascading.pipe.Boundary;
import cascading.pipe.Group;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.tap.Tap;

import static cascading.flow.planner.iso.expression.AndElementExpression.and;
import static cascading.flow.planner.iso.expression.NotElementExpression.not;
import static cascading.flow.planner.iso.expression.OrElementExpression.or;

/**
 *
 */
public class NoGroupJoinMergeBoundaryTapExpressionGraph extends ExpressionGraph
  {
  public NoGroupJoinMergeBoundaryTapExpressionGraph()
    {
    super(
      not(
        or(
          ElementCapture.Primary,
          new FlowElementExpression( Extent.class ),
          new FlowElementExpression( Group.class ),
          new FlowElementExpression( HashJoin.class ),
          and( new FlowElementExpression( Merge.class ), not( new AnnotationExpression( RoleMode.Logical ) ) ),
          new FlowElementExpression( Boundary.class ),
          new FlowElementExpression( Tap.class )
        )
      )
    );
    }
  }
