/*
 * Copyright (c) 2007-2022 The Cascading Authors. All Rights Reserved.
 *
 * Project and contact information: https://cascading.wensel.net/
 *
 * This file is part of the Cascading project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cascading.flow;

import java.io.IOException;

/**
 * Class FlowSkipIfSinkNotStale is a {@link cascading.flow.FlowSkipStrategy} implementation that returns
 * {@code true} if the Flow sink exists and is not stale in relation to the Flow sources.
 * <p>
 * This is the default Cascading strategy.
 *
 * @see cascading.flow.FlowSkipIfSinkExists
 */
public class FlowSkipIfSinkNotStale implements FlowSkipStrategy
  {
  public boolean skipFlow( Flow flow ) throws IOException
    {
    long sinkModified = flow.getSinkModified();

    return sinkModified > 0 && !flow.areSourcesNewer( sinkModified );
    }
  }
