/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest.documents;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.beans.DocumentFile;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import net.webpdf.wsclient.session.rest.documents.DocumentManager;
import net.webpdf.wsclient.session.rest.documents.RestDocumentState;
import net.webpdf.wsclient.session.rest.documents.RestWebServiceDocument;
import net.webpdf.wsclient.session.rest.documents.RestWebServiceDocumentManager;
import org.jetbrains.annotations.NotNull;

public class RestWebServiceDocumentState
implements RestDocumentState<RestWebServiceDocument> {
    @NotNull
    private final ConcurrentHashMap<Integer, HistoryEntry> historyMap = new ConcurrentHashMap();
    @NotNull
    private final AtomicReference<DocumentFile> documentFile = new AtomicReference();
    @NotNull
    private final String documentId;
    @NotNull
    private final DocumentManager<RestWebServiceDocument> documentManager;

    public RestWebServiceDocumentState(@NotNull String documentId, @NotNull RestWebServiceDocumentManager documentManager) {
        this.documentId = documentId;
        this.documentManager = documentManager;
    }

    @Override
    @NotNull
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    @NotNull
    public DocumentFile getDocumentFile() {
        return this.documentFile.get();
    }

    @Override
    public void setDocumentFile(@NotNull DocumentFile documentFile) {
        this.documentFile.set(documentFile);
    }

    @Override
    @NotNull
    public List<HistoryEntry> getHistory() {
        return new ArrayList<HistoryEntry>(this.historyMap.values());
    }

    @Override
    public void setHistory(@NotNull HistoryEntry[] historyEntries) throws ResultException {
        this.historyMap.clear();
        for (HistoryEntry historyEntry : historyEntries) {
            this.updateHistoryEntry(historyEntry);
        }
    }

    @Override
    @NotNull
    public HistoryEntry getHistoryEntry(int historyId) throws ResultException {
        if (!this.historyMap.containsKey(historyId)) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        return this.historyMap.get(historyId);
    }

    @Override
    public void updateHistoryEntry(@NotNull HistoryEntry historyEntry) throws ResultException {
        int historyId = historyEntry.getId();
        if (historyEntry.isActive()) {
            for (Map.Entry<Integer, HistoryEntry> entry : this.historyMap.entrySet()) {
                entry.getValue().setActive(false);
            }
        }
        this.historyMap.put(historyId, historyEntry);
    }

    @Override
    @NotNull
    public HistoryEntry lastHistory() throws ResultException {
        if (this.historyMap.isEmpty()) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        return this.historyMap.get(this.historyMap.size());
    }

    @Override
    public int getHistorySize() {
        return this.historyMap.size();
    }

    @Override
    @NotNull
    public HistoryEntry activeHistory() throws ResultException {
        if (this.historyMap.isEmpty()) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        Map.Entry historyEntry = this.historyMap.entrySet().stream().filter(entry -> ((HistoryEntry)entry.getValue()).isActive()).findFirst().orElse(null);
        if (historyEntry == null) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        return (HistoryEntry)historyEntry.getValue();
    }

    @Override
    @NotNull
    public DocumentManager<RestWebServiceDocument> getDocumentManager() {
        return this.documentManager;
    }
}

