/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.SessionTableEntry;
import org.jetbrains.annotations.Nullable;

@Schema(description="General information about the sessions and detailed information about each session.")
@JsonPropertyOrder(value={"activeSessions", "expiredSessions", "sessionCount", "sessionDiskUsage", "sessionFolder", "sessionId", "sessionList", "timestamp", "unstableSessions"})
@JsonTypeName(value="Session_Table")
public class SessionTable {
    public static final String JSON_PROPERTY_ACTIVE_SESSIONS = "activeSessions";
    private Long activeSessions = 0L;
    public static final String JSON_PROPERTY_EXPIRED_SESSIONS = "expiredSessions";
    private Long expiredSessions = 0L;
    public static final String JSON_PROPERTY_SESSION_COUNT = "sessionCount";
    private Long sessionCount = 0L;
    public static final String JSON_PROPERTY_SESSION_DISK_USAGE = "sessionDiskUsage";
    private Long sessionDiskUsage = 0L;
    public static final String JSON_PROPERTY_SESSION_FOLDER = "sessionFolder";
    private String sessionFolder = "";
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId = "";
    public static final String JSON_PROPERTY_SESSION_LIST = "sessionList";
    private List<SessionTableEntry> sessionList = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp = 0L;
    public static final String JSON_PROPERTY_UNSTABLE_SESSIONS = "unstableSessions";
    private Long unstableSessions = 0L;

    public SessionTable activeSessions(Long activeSessions) {
        this.activeSessions = activeSessions;
        return this;
    }

    @Schema(name="Total number of active sessions.")
    @JsonProperty(value="activeSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getActiveSessions() {
        return this.activeSessions;
    }

    @JsonProperty(value="activeSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActiveSessions(Long activeSessions) {
        this.activeSessions = activeSessions;
    }

    public SessionTable expiredSessions(Long expiredSessions) {
        this.expiredSessions = expiredSessions;
        return this;
    }

    @Schema(name="Total number of expired sessions.")
    @JsonProperty(value="expiredSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getExpiredSessions() {
        return this.expiredSessions;
    }

    @JsonProperty(value="expiredSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiredSessions(Long expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public SessionTable sessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
        return this;
    }

    @Schema(name="Total number of sessions.")
    @JsonProperty(value="sessionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getSessionCount() {
        return this.sessionCount;
    }

    @JsonProperty(value="sessionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
    }

    public SessionTable sessionDiskUsage(Long sessionDiskUsage) {
        this.sessionDiskUsage = sessionDiskUsage;
        return this;
    }

    @Schema(name="Total size in bytes required by all sessions together on the hard disk in the base folder.")
    @JsonProperty(value="sessionDiskUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getSessionDiskUsage() {
        return this.sessionDiskUsage;
    }

    @JsonProperty(value="sessionDiskUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionDiskUsage(Long sessionDiskUsage) {
        this.sessionDiskUsage = sessionDiskUsage;
    }

    public SessionTable sessionFolder(String sessionFolder) {
        this.sessionFolder = sessionFolder;
        return this;
    }

    @Schema(name="Base folder for all session data (e.g. files and file history).")
    @JsonProperty(value="sessionFolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSessionFolder() {
        return this.sessionFolder;
    }

    @JsonProperty(value="sessionFolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionFolder(String sessionFolder) {
        this.sessionFolder = sessionFolder;
    }

    public SessionTable sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Schema(name="Session ID of the session that requested the session table.")
    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SessionTable sessionList(List<SessionTableEntry> sessionList) {
        this.sessionList = sessionList;
        return this;
    }

    public SessionTable addSessionListItem(SessionTableEntry sessionListItem) {
        if (this.sessionList == null) {
            this.sessionList = new ArrayList<SessionTableEntry>();
        }
        this.sessionList.add(sessionListItem);
        return this;
    }

    @Schema(name="List of all sessions and detailed information about each session.")
    @JsonProperty(value="sessionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<SessionTableEntry> getSessionList() {
        return this.sessionList;
    }

    @JsonProperty(value="sessionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionList(List<SessionTableEntry> sessionList) {
        this.sessionList = sessionList;
    }

    public SessionTable timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Schema(name="UTC time when the query was executed.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public SessionTable unstableSessions(Long unstableSessions) {
        this.unstableSessions = unstableSessions;
        return this;
    }

    @Schema(name="Total number of sessions that have not yet been initialized or are currently expiring.")
    @JsonProperty(value="unstableSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getUnstableSessions() {
        return this.unstableSessions;
    }

    @JsonProperty(value="unstableSessions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnstableSessions(Long unstableSessions) {
        this.unstableSessions = unstableSessions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTable sessionTable = (SessionTable)o;
        return Objects.equals(this.activeSessions, sessionTable.activeSessions) && Objects.equals(this.expiredSessions, sessionTable.expiredSessions) && Objects.equals(this.sessionCount, sessionTable.sessionCount) && Objects.equals(this.sessionDiskUsage, sessionTable.sessionDiskUsage) && Objects.equals(this.sessionFolder, sessionTable.sessionFolder) && Objects.equals(this.sessionId, sessionTable.sessionId) && Objects.equals(this.sessionList, sessionTable.sessionList) && Objects.equals(this.timestamp, sessionTable.timestamp) && Objects.equals(this.unstableSessions, sessionTable.unstableSessions);
    }

    public int hashCode() {
        return Objects.hash(this.activeSessions, this.expiredSessions, this.sessionCount, this.sessionDiskUsage, this.sessionFolder, this.sessionId, this.sessionList, this.timestamp, this.unstableSessions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionTable {\n");
        sb.append("    activeSessions: ").append(this.toIndentedString(this.activeSessions)).append("\n");
        sb.append("    expiredSessions: ").append(this.toIndentedString(this.expiredSessions)).append("\n");
        sb.append("    sessionCount: ").append(this.toIndentedString(this.sessionCount)).append("\n");
        sb.append("    sessionDiskUsage: ").append(this.toIndentedString(this.sessionDiskUsage)).append("\n");
        sb.append("    sessionFolder: ").append(this.toIndentedString(this.sessionFolder)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    sessionList: ").append(this.toIndentedString(this.sessionList)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    unstableSessions: ").append(this.toIndentedString(this.unstableSessions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

