/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the port and command for the server shutdown.")
@JsonPropertyOrder(value={"command", "port", "restart"})
@JsonTypeName(value="ServerConfig_Shutdown")
public class ServerConfigShutdown {
    public static final String JSON_PROPERTY_COMMAND = "command";
    private String command = "SHUTDOWN";
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 8005;
    public static final String JSON_PROPERTY_RESTART = "restart";
    private Boolean restart = true;

    public ServerConfigShutdown command(String command) {
        this.command = command;
        return this;
    }

    @Schema(name="The command, that shall be listened for.")
    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommand(String command) {
        this.command = command;
    }

    public ServerConfigShutdown port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port, that shall listen for shutdown commands.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public ServerConfigShutdown restart(Boolean restart) {
        this.restart = restart;
        return this;
    }

    @Schema(name="When set to true, the server will restart upon the shutdown's completion. Otherwise, the server will be stopped after the command.")
    @JsonProperty(value="restart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRestart() {
        return this.restart;
    }

    @JsonProperty(value="restart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigShutdown serverConfigShutdown = (ServerConfigShutdown)o;
        return Objects.equals(this.command, serverConfigShutdown.command) && Objects.equals(this.port, serverConfigShutdown.port) && Objects.equals(this.restart, serverConfigShutdown.restart);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.port, this.restart);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigShutdown {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    restart: ").append(this.toIndentedString(this.restart)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

