/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Schema(description="Lists the protocols, that are accepted by the TLS connector.")
@JsonPropertyOrder(value={"protocol"})
@JsonTypeName(value="ServerConfig_ProtocolsSSL")
public class ServerConfigProtocolsSSL {
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private List<ProtocolEnum> protocol = new ArrayList<ProtocolEnum>();

    public ServerConfigProtocolsSSL protocol(List<ProtocolEnum> protocol) {
        this.protocol = protocol;
        return this;
    }

    public ServerConfigProtocolsSSL addProtocolItem(ProtocolEnum protocolItem) {
        this.protocol.add(protocolItem);
        return this;
    }

    @Schema(required=true, name="Selects a TLS protocol for the connector.")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<ProtocolEnum> getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProtocol(List<ProtocolEnum> protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigProtocolsSSL serverConfigProtocolsSSL = (ServerConfigProtocolsSSL)o;
        return Objects.equals(this.protocol, serverConfigProtocolsSSL.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigProtocolsSSL {\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProtocolEnum {
        TLSV1("TLSv1"),
        TLSV1_1("TLSv1.1"),
        TLSV1_2("TLSv1.2"),
        TLSV1_3("TLSv1.3");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

