/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Sets the keystore information for the server key and certificate to be used to cipher the connection. This keystore may only contain exactly one certificate or certificate chain with one private key.")
@JsonPropertyOrder(value={"alias", "file", "password", "type"})
@JsonTypeName(value="ServerConfig_KeystoreSSL")
public class ServerConfigKeystoreSSL {
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias = "";
    public static final String JSON_PROPERTY_FILE = "file";
    private String _file = "ssl.jks";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "webpdf";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.JKS;

    public ServerConfigKeystoreSSL alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(name="The alias used for the server key and certificate in the keystore.")
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ServerConfigKeystoreSSL _file(String _file) {
        this._file = _file;
        return this;
    }

    @Schema(name="The name of the keystore file to use.")
    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFile() {
        return this._file;
    }

    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFile(String _file) {
        this._file = _file;
    }

    public ServerConfigKeystoreSSL password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password required to access the keystore.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public ServerConfigKeystoreSSL type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="The format of the keystore file.  *   JKS = A Java keystore (file based with an extension like \".jks\"). *   PKCS12 = A PKCS12 keystore (file based with the extensions like \".p12\" or \".pfx\").")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigKeystoreSSL serverConfigKeystoreSSL = (ServerConfigKeystoreSSL)o;
        return Objects.equals(this.alias, serverConfigKeystoreSSL.alias) && Objects.equals(this._file, serverConfigKeystoreSSL._file) && Objects.equals(this.password, serverConfigKeystoreSSL.password) && Objects.equals((Object)this.type, (Object)serverConfigKeystoreSSL.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this._file, this.password, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigKeystoreSSL {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        JKS("JKS"),
        PKCS12("PKCS12");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

