/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationBackgroundToolboxOptions;
import net.webpdf.wsclient.openapi.OperationBoxesToolboxOptions;
import net.webpdf.wsclient.openapi.OperationHeaderFooterToolboxOptions;
import net.webpdf.wsclient.openapi.OperationPageTransitionsToolboxOptions;
import net.webpdf.wsclient.openapi.OperationViewerPreferences;
import org.jetbrains.annotations.Nullable;

@Schema(description="The options operation element can be used to change the way documents are displayed.  **Tip:** For all hereby contained options, please consult the chapter \"Display Options\". This is especially important concerning the content format of headers and footers.")
@JsonPropertyOrder(value={"background", "boxes", "headerFooter", "initialPage", "initialView", "language", "magnification", "magnificationZoom", "pageLayout", "pageTransitions", "viewerPreferences"})
@JsonTypeName(value="Operation_ToolboxOptions_options")
public class OperationToolboxOptionsOptions {
    public static final String JSON_PROPERTY_BACKGROUND = "background";
    private OperationBackgroundToolboxOptions background;
    public static final String JSON_PROPERTY_BOXES = "boxes";
    private OperationBoxesToolboxOptions boxes;
    public static final String JSON_PROPERTY_HEADER_FOOTER = "headerFooter";
    private OperationHeaderFooterToolboxOptions headerFooter;
    public static final String JSON_PROPERTY_INITIAL_PAGE = "initialPage";
    private Integer initialPage = 1;
    public static final String JSON_PROPERTY_INITIAL_VIEW = "initialView";
    private InitialViewEnum initialView = InitialViewEnum.NONE;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language = "";
    public static final String JSON_PROPERTY_MAGNIFICATION = "magnification";
    private MagnificationEnum magnification = MagnificationEnum.FITWIDTH;
    public static final String JSON_PROPERTY_MAGNIFICATION_ZOOM = "magnificationZoom";
    private Integer magnificationZoom = 100;
    public static final String JSON_PROPERTY_PAGE_LAYOUT = "pageLayout";
    private PageLayoutEnum pageLayout = PageLayoutEnum.SINGLEPAGE;
    public static final String JSON_PROPERTY_PAGE_TRANSITIONS = "pageTransitions";
    private OperationPageTransitionsToolboxOptions pageTransitions;
    public static final String JSON_PROPERTY_VIEWER_PREFERENCES = "viewerPreferences";
    private OperationViewerPreferences viewerPreferences;

    public OperationToolboxOptionsOptions background(OperationBackgroundToolboxOptions background) {
        this.background = background;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationBackgroundToolboxOptions getBackground() {
        return this.background;
    }

    @JsonProperty(value="background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackground(OperationBackgroundToolboxOptions background) {
        this.background = background;
    }

    public OperationToolboxOptionsOptions boxes(OperationBoxesToolboxOptions boxes) {
        this.boxes = boxes;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="boxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationBoxesToolboxOptions getBoxes() {
        return this.boxes;
    }

    @JsonProperty(value="boxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBoxes(OperationBoxesToolboxOptions boxes) {
        this.boxes = boxes;
    }

    public OperationToolboxOptionsOptions headerFooter(OperationHeaderFooterToolboxOptions headerFooter) {
        this.headerFooter = headerFooter;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="headerFooter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationHeaderFooterToolboxOptions getHeaderFooter() {
        return this.headerFooter;
    }

    @JsonProperty(value="headerFooter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaderFooter(OperationHeaderFooterToolboxOptions headerFooter) {
        this.headerFooter = headerFooter;
    }

    public OperationToolboxOptionsOptions initialPage(Integer initialPage) {
        this.initialPage = initialPage;
        return this;
    }

    @Schema(name="Defines the page that will be shown when the document is opened.")
    @JsonProperty(value="initialPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getInitialPage() {
        return this.initialPage;
    }

    @JsonProperty(value="initialPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialPage(Integer initialPage) {
        this.initialPage = initialPage;
    }

    public OperationToolboxOptionsOptions initialView(InitialViewEnum initialView) {
        this.initialView = initialView;
        return this;
    }

    @Schema(name="Defines which sub-windows will be opened when the PDF document is opened.  *   none = No special view *   outlines = Opens the \"Bookmarks\" tab *   thumbnails = Opens the \"Thumbnails\" tab *   fullscreen = Opens the document in full screen mode")
    @JsonProperty(value="initialView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public InitialViewEnum getInitialView() {
        return this.initialView;
    }

    @JsonProperty(value="initialView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialView(InitialViewEnum initialView) {
        this.initialView = initialView;
    }

    public OperationToolboxOptionsOptions language(String language) {
        this.language = language;
        return this;
    }

    @Schema(name="Specifies the language (and optionally the country) for the content of the document. The value is encoded as RFC 3066 (Tags for the Identification of Languages) and includes either the language only (e.g. \"de\") or the language and a country identifier (e.g. \"de-DE\").")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public OperationToolboxOptionsOptions magnification(MagnificationEnum magnification) {
        this.magnification = magnification;
        return this;
    }

    @Schema(name="Sets the zoom settings according to a defined mode.  *   none = Uses the application's default view *   fitWidth = Page width *   fitPage = Page dimensions *   fitHeight = Page height *   fitVisible = Page content width *   fitActual = Uses the original page dimensions (100% zoom factor) *   zoom = Sets an explicit magnification value")
    @JsonProperty(value="magnification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MagnificationEnum getMagnification() {
        return this.magnification;
    }

    @JsonProperty(value="magnification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMagnification(MagnificationEnum magnification) {
        this.magnification = magnification;
    }

    public OperationToolboxOptionsOptions magnificationZoom(Integer magnificationZoom) {
        this.magnificationZoom = magnificationZoom;
        return this;
    }

    @Schema(name="Used to set the value for zooming.")
    @JsonProperty(value="magnificationZoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMagnificationZoom() {
        return this.magnificationZoom;
    }

    @JsonProperty(value="magnificationZoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMagnificationZoom(Integer magnificationZoom) {
        this.magnificationZoom = magnificationZoom;
    }

    public OperationToolboxOptionsOptions pageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
        return this;
    }

    @Schema(name="Sets the page layout when the PDF document is opened.  *   singlePage = Individual pages *   singlePageContinous = Continuous individual pages *   twoPages = double pages starting with odd pages *   twoPagesRight = double pages starting with even pages *   twoPagesContinous = continuous double pages starting with odd pages *   twoPagesContinousRight = continuous double pages starting with even pages")
    @JsonProperty(value="pageLayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PageLayoutEnum getPageLayout() {
        return this.pageLayout;
    }

    @JsonProperty(value="pageLayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
    }

    public OperationToolboxOptionsOptions pageTransitions(OperationPageTransitionsToolboxOptions pageTransitions) {
        this.pageTransitions = pageTransitions;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pageTransitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPageTransitionsToolboxOptions getPageTransitions() {
        return this.pageTransitions;
    }

    @JsonProperty(value="pageTransitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageTransitions(OperationPageTransitionsToolboxOptions pageTransitions) {
        this.pageTransitions = pageTransitions;
    }

    public OperationToolboxOptionsOptions viewerPreferences(OperationViewerPreferences viewerPreferences) {
        this.viewerPreferences = viewerPreferences;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="viewerPreferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationViewerPreferences getViewerPreferences() {
        return this.viewerPreferences;
    }

    @JsonProperty(value="viewerPreferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewerPreferences(OperationViewerPreferences viewerPreferences) {
        this.viewerPreferences = viewerPreferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxOptionsOptions operationToolboxOptionsOptions = (OperationToolboxOptionsOptions)o;
        return Objects.equals(this.background, operationToolboxOptionsOptions.background) && Objects.equals(this.boxes, operationToolboxOptionsOptions.boxes) && Objects.equals(this.headerFooter, operationToolboxOptionsOptions.headerFooter) && Objects.equals(this.initialPage, operationToolboxOptionsOptions.initialPage) && Objects.equals((Object)this.initialView, (Object)operationToolboxOptionsOptions.initialView) && Objects.equals(this.language, operationToolboxOptionsOptions.language) && Objects.equals((Object)this.magnification, (Object)operationToolboxOptionsOptions.magnification) && Objects.equals(this.magnificationZoom, operationToolboxOptionsOptions.magnificationZoom) && Objects.equals((Object)this.pageLayout, (Object)operationToolboxOptionsOptions.pageLayout) && Objects.equals(this.pageTransitions, operationToolboxOptionsOptions.pageTransitions) && Objects.equals(this.viewerPreferences, operationToolboxOptionsOptions.viewerPreferences);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.background, this.boxes, this.headerFooter, this.initialPage, this.initialView, this.language, this.magnification, this.magnificationZoom, this.pageLayout, this.pageTransitions, this.viewerPreferences});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxOptionsOptions {\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    boxes: ").append(this.toIndentedString(this.boxes)).append("\n");
        sb.append("    headerFooter: ").append(this.toIndentedString(this.headerFooter)).append("\n");
        sb.append("    initialPage: ").append(this.toIndentedString(this.initialPage)).append("\n");
        sb.append("    initialView: ").append(this.toIndentedString((Object)this.initialView)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    magnification: ").append(this.toIndentedString((Object)this.magnification)).append("\n");
        sb.append("    magnificationZoom: ").append(this.toIndentedString(this.magnificationZoom)).append("\n");
        sb.append("    pageLayout: ").append(this.toIndentedString((Object)this.pageLayout)).append("\n");
        sb.append("    pageTransitions: ").append(this.toIndentedString(this.pageTransitions)).append("\n");
        sb.append("    viewerPreferences: ").append(this.toIndentedString(this.viewerPreferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PageLayoutEnum {
        SINGLEPAGE("singlePage"),
        SINGLEPAGECONTINOUS("singlePageContinous"),
        TWOPAGES("twoPages"),
        TWOPAGESRIGHT("twoPagesRight"),
        TWOPAGESCONTINOUS("twoPagesContinous"),
        TWOPAGESCONTINOUSRIGHT("twoPagesContinousRight");

        private String value;

        private PageLayoutEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PageLayoutEnum fromValue(String value) {
            for (PageLayoutEnum b : PageLayoutEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MagnificationEnum {
        NONE("none"),
        FITWIDTH("fitWidth"),
        FITVISIBLE("fitVisible"),
        FITHEIGHT("fitHeight"),
        FITPAGE("fitPage"),
        FITACTUAL("fitActual"),
        ZOOM("zoom");

        private String value;

        private MagnificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MagnificationEnum fromValue(String value) {
            for (MagnificationEnum b : MagnificationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InitialViewEnum {
        NONE("none"),
        OUTLINES("outlines"),
        THUMBNAILS("thumbnails"),
        FULLSCREEN("fullscreen"),
        LAYERS("layers"),
        ATTACHMENTS("attachments");

        private String value;

        private InitialViewEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitialViewEnum fromValue(String value) {
            for (InitialViewEnum b : InitialViewEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

