/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="When activated, the playSound Element plays the specified audio data.")
@JsonPropertyOrder(value={"encoding", "mix", "repeat", "sampleSize", "samplingRate", "sound", "soundChannels", "synchronous", "volume"})
@JsonTypeName(value="Operation_SoundAction_playSound")
public class OperationSoundActionPlaySound {
    public static final String JSON_PROPERTY_ENCODING = "encoding";
    private EncodingEnum encoding = EncodingEnum.RAW;
    public static final String JSON_PROPERTY_MIX = "mix";
    private Boolean mix = false;
    public static final String JSON_PROPERTY_REPEAT = "repeat";
    private Boolean repeat = false;
    public static final String JSON_PROPERTY_SAMPLE_SIZE = "sampleSize";
    private Integer sampleSize = 8;
    public static final String JSON_PROPERTY_SAMPLING_RATE = "samplingRate";
    private Float samplingRate = Float.valueOf(8000.0f);
    public static final String JSON_PROPERTY_SOUND = "sound";
    private byte[] sound;
    public static final String JSON_PROPERTY_SOUND_CHANNELS = "soundChannels";
    private Integer soundChannels = 1;
    public static final String JSON_PROPERTY_SYNCHRONOUS = "synchronous";
    private Boolean synchronous = false;
    public static final String JSON_PROPERTY_VOLUME = "volume";
    private Integer volume = 100;

    public OperationSoundActionPlaySound encoding(EncodingEnum encoding) {
        this.encoding = encoding;
        return this;
    }

    @Schema(name="The encoding of the audio file. Possible values are:  *   Raw *   Signed *   muLaw *   ALaw")
    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public EncodingEnum getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncoding(EncodingEnum encoding) {
        this.encoding = encoding;
    }

    public OperationSoundActionPlaySound mix(Boolean mix) {
        this.mix = mix;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to play the audio track at the same time as other audio tracks. If it is set to false instead, any audio tracks that were already playing will be stopped previously.")
    @JsonProperty(value="mix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getMix() {
        return this.mix;
    }

    @JsonProperty(value="mix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMix(Boolean mix) {
        this.mix = mix;
    }

    public OperationSoundActionPlaySound repeat(Boolean repeat) {
        this.repeat = repeat;
        return this;
    }

    @Schema(name="If this value is set to true, the audio track should be repeated endlessly.")
    @JsonProperty(value="repeat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRepeat() {
        return this.repeat;
    }

    @JsonProperty(value="repeat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRepeat(Boolean repeat) {
        this.repeat = repeat;
    }

    public OperationSoundActionPlaySound sampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    @Schema(name="The number of bits per sample per audio channel.")
    @JsonProperty(value="sampleSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @JsonProperty(value="sampleSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public OperationSoundActionPlaySound samplingRate(Float samplingRate) {
        this.samplingRate = samplingRate;
        return this;
    }

    @Schema(name="The Sample Rate in Samples per Second.")
    @JsonProperty(value="samplingRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getSamplingRate() {
        return this.samplingRate;
    }

    @JsonProperty(value="samplingRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamplingRate(Float samplingRate) {
        this.samplingRate = samplingRate;
    }

    public OperationSoundActionPlaySound sound(byte[] sound) {
        this.sound = sound;
        return this;
    }

    @Schema(required=true, name="The audio file that should be played. The file must be encoded as a BASE64 value. The passed file must be completely independent and contain all the information and data required to play it. The AIFF, AIFF-C, RIFF (\\*.wav), snd(\\*.au) audio formats are supported, for example.")
    @JsonProperty(value="sound")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public byte[] getSound() {
        return this.sound;
    }

    @JsonProperty(value="sound")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSound(byte[] sound) {
        this.sound = sound;
    }

    public OperationSoundActionPlaySound soundChannels(Integer soundChannels) {
        this.soundChannels = soundChannels;
        return this;
    }

    @Schema(name="The number of audio channels.")
    @JsonProperty(value="soundChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSoundChannels() {
        return this.soundChannels;
    }

    @JsonProperty(value="soundChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoundChannels(Integer soundChannels) {
        this.soundChannels = soundChannels;
    }

    public OperationSoundActionPlaySound synchronous(Boolean synchronous) {
        this.synchronous = synchronous;
        return this;
    }

    @Schema(name="If this value is set to true, the reader program must guarantee that the audio track will be plated in a completely synchronized manner without any interruptions and, accordingly, suppress any user interaction (except for cancelling the audio) while the audio is playing.")
    @JsonProperty(value="synchronous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSynchronous() {
        return this.synchronous;
    }

    @JsonProperty(value="synchronous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public OperationSoundActionPlaySound volume(Integer volume) {
        this.volume = volume;
        return this;
    }

    @Schema(name="A floating-point number between 100 and -100 that configures the volume for audio playback (as a percentage).")
    @JsonProperty(value="volume")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getVolume() {
        return this.volume;
    }

    @JsonProperty(value="volume")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSoundActionPlaySound operationSoundActionPlaySound = (OperationSoundActionPlaySound)o;
        return Objects.equals((Object)this.encoding, (Object)operationSoundActionPlaySound.encoding) && Objects.equals(this.mix, operationSoundActionPlaySound.mix) && Objects.equals(this.repeat, operationSoundActionPlaySound.repeat) && Objects.equals(this.sampleSize, operationSoundActionPlaySound.sampleSize) && Objects.equals(this.samplingRate, operationSoundActionPlaySound.samplingRate) && Arrays.equals(this.sound, operationSoundActionPlaySound.sound) && Objects.equals(this.soundChannels, operationSoundActionPlaySound.soundChannels) && Objects.equals(this.synchronous, operationSoundActionPlaySound.synchronous) && Objects.equals(this.volume, operationSoundActionPlaySound.volume);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.encoding, this.mix, this.repeat, this.sampleSize, this.samplingRate, Arrays.hashCode(this.sound), this.soundChannels, this.synchronous, this.volume});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSoundActionPlaySound {\n");
        sb.append("    encoding: ").append(this.toIndentedString((Object)this.encoding)).append("\n");
        sb.append("    mix: ").append(this.toIndentedString(this.mix)).append("\n");
        sb.append("    repeat: ").append(this.toIndentedString(this.repeat)).append("\n");
        sb.append("    sampleSize: ").append(this.toIndentedString(this.sampleSize)).append("\n");
        sb.append("    samplingRate: ").append(this.toIndentedString(this.samplingRate)).append("\n");
        sb.append("    sound: ").append(this.toIndentedString(this.sound)).append("\n");
        sb.append("    soundChannels: ").append(this.toIndentedString(this.soundChannels)).append("\n");
        sb.append("    synchronous: ").append(this.toIndentedString(this.synchronous)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EncodingEnum {
        RAW("Raw"),
        SIGNED("Signed"),
        MULAW("muLaw"),
        ALAW("ALaw");

        private String value;

        private EncodingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncodingEnum fromValue(String value) {
            for (EncodingEnum b : EncodingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

