/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Selects a specific box of a given page range of a PDF document.")
@JsonPropertyOrder(value={"box", "pages"})
@JsonTypeName(value="Operation_SelectionBox")
public class OperationSelectionBox {
    public static final String JSON_PROPERTY_BOX = "box";
    private BoxEnum box = BoxEnum.CROP_BOX;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "*";

    public OperationSelectionBox box(BoxEnum box) {
        this.box = box;
        return this;
    }

    @Schema(name="Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="box")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public BoxEnum getBox() {
        return this.box;
    }

    @JsonProperty(value="box")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBox(BoxEnum box) {
        this.box = box;
    }

    public OperationSelectionBox pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define the page(s) from which boxes should be removed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSelectionBox operationSelectionBox = (OperationSelectionBox)o;
        return Objects.equals((Object)this.box, (Object)operationSelectionBox.box) && Objects.equals(this.pages, operationSelectionBox.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.box, this.pages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSelectionBox {\n");
        sb.append("    box: ").append(this.toIndentedString((Object)this.box)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BoxEnum {
        MEDIA_BOX("media_box"),
        CROP_BOX("crop_box"),
        BLEED_BOX("bleed_box"),
        TRIM_BOX("trim_box"),
        ART_BOX("art_box");

        private String value;

        private BoxEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BoxEnum fromValue(String value) {
            for (BoxEnum b : BoxEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

