/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to position the barcode in a PDF document.")
@JsonPropertyOrder(value={"mode", "page"})
@JsonTypeName(value="Operation_QrSwissPaymentPdf")
public class OperationQrSwissPaymentPdf {
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.APPENDATEND;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;

    public OperationQrSwissPaymentPdf mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Selects the page relative position to place the barcode at.  *   insertBefore = Places the barcode on a new, empty page before the selected page. *   appendAtEnd = Places the barcode on a new, empty page at the end of the document. *   addToPage = Place the barcode on the selected page.")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public OperationQrSwissPaymentPdf page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The number of the page, the barcode shall be placed at or relative to. (depending on the selected placement \"mode\".)")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationQrSwissPaymentPdf operationQrSwissPaymentPdf = (OperationQrSwissPaymentPdf)o;
        return Objects.equals((Object)this.mode, (Object)operationQrSwissPaymentPdf.mode) && Objects.equals(this.page, operationQrSwissPaymentPdf.page);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.page});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationQrSwissPaymentPdf {\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        INSERTBEFORE("insertBefore"),
        APPENDATEND("appendAtEnd"),
        ADDTOPAGE("addToPage");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

