/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define the document page range to which new elements should be added. Can be used to define a fixed interval from one page to another page.")
@JsonPropertyOrder(value={"even", "odd", "pages"})
@JsonTypeName(value="Operation_PageInterval")
public class OperationPageInterval {
    public static final String JSON_PROPERTY_EVEN = "even";
    private Boolean even = true;
    public static final String JSON_PROPERTY_ODD = "odd";
    private Boolean odd = true;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "*";

    public OperationPageInterval even(Boolean even) {
        this.even = even;
        return this;
    }

    @Schema(name="If true, the elements are also placed on even-numbered pages.")
    @JsonProperty(value="even")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEven() {
        return this.even;
    }

    @JsonProperty(value="even")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEven(Boolean even) {
        this.even = even;
    }

    public OperationPageInterval odd(Boolean odd) {
        this.odd = odd;
        return this;
    }

    @Schema(name="If true, the elements are also placed on pages with odd-numbered pages.")
    @JsonProperty(value="odd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getOdd() {
        return this.odd;
    }

    @JsonProperty(value="odd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOdd(Boolean odd) {
        this.odd = odd;
    }

    public OperationPageInterval pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Defines the pages of the PDF document to which new elements should be added. Either a single page or a range of pages (e.g., \"1-5\") can be defined. (Can only be used to define a single contiguous interval of consecutive pages.)")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPageInterval operationPageInterval = (OperationPageInterval)o;
        return Objects.equals(this.even, operationPageInterval.even) && Objects.equals(this.odd, operationPageInterval.odd) && Objects.equals(this.pages, operationPageInterval.pages);
    }

    public int hashCode() {
        return Objects.hash(this.even, this.odd, this.pages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPageInterval {\n");
        sb.append("    even: ").append(this.toIndentedString(this.even)).append("\n");
        sb.append("    odd: ").append(this.toIndentedString(this.odd)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

