/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationImageOptimization;
import net.webpdf.wsclient.openapi.OperationOcrPage;
import net.webpdf.wsclient.openapi.OperationPdfa;
import org.jetbrains.annotations.Nullable;

@Schema(description="The \"OCR\" web service can be used to run character recognition in PDF documents or images. If recognition is run on images, they will be converted to PDF documents. More specifically, a page will be generated for each image in the PDF document, with this page containing the original image and a text layer with the recognized text. Character recognition on PDF documents will only work with documents that do not contain text already. Normally, these will be documents that were generated by scanners and that only have an image per page in the PDF document.")
@JsonPropertyOrder(value={"checkResolution", "failOnWarning", "forceEachPage", "imageDpi", "jpegQuality", "language", "normalizePageRotation", "ocrMode", "optimization", "outputFormat", "page", "pdfa"})
@JsonTypeName(value="Operation_Ocr")
public class OperationOcr {
    public static final String JSON_PROPERTY_CHECK_RESOLUTION = "checkResolution";
    private Boolean checkResolution = true;
    public static final String JSON_PROPERTY_FAIL_ON_WARNING = "failOnWarning";
    private Boolean failOnWarning = false;
    public static final String JSON_PROPERTY_FORCE_EACH_PAGE = "forceEachPage";
    private Boolean forceEachPage = false;
    public static final String JSON_PROPERTY_IMAGE_DPI = "imageDpi";
    private Integer imageDpi = 200;
    public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
    private Integer jpegQuality = 75;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private LanguageEnum language = LanguageEnum.ENG;
    public static final String JSON_PROPERTY_NORMALIZE_PAGE_ROTATION = "normalizePageRotation";
    private Boolean normalizePageRotation = false;
    public static final String JSON_PROPERTY_OCR_MODE = "ocrMode";
    private OcrModeEnum ocrMode = OcrModeEnum.PAGESEGMENTS;
    public static final String JSON_PROPERTY_OPTIMIZATION = "optimization";
    private OperationImageOptimization optimization;
    public static final String JSON_PROPERTY_OUTPUT_FORMAT = "outputFormat";
    private OutputFormatEnum outputFormat = OutputFormatEnum.PDF;
    public static final String JSON_PROPERTY_PAGE = "page";
    private OperationOcrPage page;
    public static final String JSON_PROPERTY_PDFA = "pdfa";
    private OperationPdfa pdfa;

    public OperationOcr checkResolution(Boolean checkResolution) {
        this.checkResolution = checkResolution;
        return this;
    }

    @Schema(name="If \"true,\" then the DPI resolution of the output file will be checked. Resolutions of less than 200 DPI are rejected in this check because as a rule, they do not produce good results for character recognition.")
    @JsonProperty(value="checkResolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCheckResolution() {
        return this.checkResolution;
    }

    @JsonProperty(value="checkResolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckResolution(Boolean checkResolution) {
        this.checkResolution = checkResolution;
    }

    public OperationOcr failOnWarning(Boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
        return this;
    }

    @Schema(name="If \"true\", character recognition will fail even in the event of warnings that do not prevent recognition, but that make it very unlikely for a meaningful result to be generated.")
    @JsonProperty(value="failOnWarning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFailOnWarning() {
        return this.failOnWarning;
    }

    @JsonProperty(value="failOnWarning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailOnWarning(Boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public OperationOcr forceEachPage(Boolean forceEachPage) {
        this.forceEachPage = forceEachPage;
        return this;
    }

    @Schema(name="If a PDF document contains text content on any page, the web service will refuse to run character recognition again. If, however, a value of \"true\" is passed for this option, all the pages in the document will be considered individually and character recognition will be run on all pages that do not contain text (layers) so that a new layer with text will be generated for them.")
    @JsonProperty(value="forceEachPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getForceEachPage() {
        return this.forceEachPage;
    }

    @JsonProperty(value="forceEachPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForceEachPage(Boolean forceEachPage) {
        this.forceEachPage = forceEachPage;
    }

    public OperationOcr imageDpi(Integer imageDpi) {
        this.imageDpi = imageDpi;
        return this;
    }

    @Schema(name="Used to set the minimum resolution images will be embedded with in resulting PDF documents. When a value of 0 is set for this parameter, the images shall be embedded using resolutions and dimensions as close as possible to the original source images.")
    @JsonProperty(value="imageDpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getImageDpi() {
        return this.imageDpi;
    }

    @JsonProperty(value="imageDpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageDpi(Integer imageDpi) {
        this.imageDpi = imageDpi;
    }

    public OperationOcr jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @Schema(name="A percentage that sets the compression ratio and influences the quality of JPEG images, that shall be embedded in resulting PDF documents. Higher values will result in less compressed images of higher quality.")
    @JsonProperty(value="jpegQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    @JsonProperty(value="jpegQuality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public OperationOcr language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @Schema(name="Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the \"special characters\" of the respective language (e.g. \"\u00fc\u00e4\u00f6\" in German) can be recognized better. At present, the following languages are supported:  *   eng = English *   fra = French *   spa = Spanish *   deu = German *   ita = Italian")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public LanguageEnum getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public OperationOcr normalizePageRotation(Boolean normalizePageRotation) {
        this.normalizePageRotation = normalizePageRotation;
        return this;
    }

    @Schema(name="If \"true\", then, for the recognition of a rotated text, the system will attempt to rotate the page in such a way that the text in the document will not appear to be rotated and will be shown \"upright.\"")
    @JsonProperty(value="normalizePageRotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getNormalizePageRotation() {
        return this.normalizePageRotation;
    }

    @JsonProperty(value="normalizePageRotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNormalizePageRotation(Boolean normalizePageRotation) {
        this.normalizePageRotation = normalizePageRotation;
    }

    public OperationOcr ocrMode(OcrModeEnum ocrMode) {
        this.ocrMode = ocrMode;
        return this;
    }

    @Schema(name="Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.  *   pageSegments = The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present. *   column = The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform. *   unfiltered = No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.")
    @JsonProperty(value="ocrMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OcrModeEnum getOcrMode() {
        return this.ocrMode;
    }

    @JsonProperty(value="ocrMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOcrMode(OcrModeEnum ocrMode) {
        this.ocrMode = ocrMode;
    }

    public OperationOcr optimization(OperationImageOptimization optimization) {
        this.optimization = optimization;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="optimization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationImageOptimization getOptimization() {
        return this.optimization;
    }

    @JsonProperty(value="optimization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptimization(OperationImageOptimization optimization) {
        this.optimization = optimization;
    }

    public OperationOcr outputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Schema(name="Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).  *   text = Text *   hocr = XML (hOCR) *   pdf = PDF")
    @JsonProperty(value="outputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    @JsonProperty(value="outputFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public OperationOcr page(OperationOcrPage page) {
        this.page = page;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationOcrPage getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(OperationOcrPage page) {
        this.page = page;
    }

    public OperationOcr pdfa(OperationPdfa pdfa) {
        this.pdfa = pdfa;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pdfa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPdfa getPdfa() {
        return this.pdfa;
    }

    @JsonProperty(value="pdfa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPdfa(OperationPdfa pdfa) {
        this.pdfa = pdfa;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationOcr operationOcr = (OperationOcr)o;
        return Objects.equals(this.checkResolution, operationOcr.checkResolution) && Objects.equals(this.failOnWarning, operationOcr.failOnWarning) && Objects.equals(this.forceEachPage, operationOcr.forceEachPage) && Objects.equals(this.imageDpi, operationOcr.imageDpi) && Objects.equals(this.jpegQuality, operationOcr.jpegQuality) && Objects.equals((Object)this.language, (Object)operationOcr.language) && Objects.equals(this.normalizePageRotation, operationOcr.normalizePageRotation) && Objects.equals((Object)this.ocrMode, (Object)operationOcr.ocrMode) && Objects.equals(this.optimization, operationOcr.optimization) && Objects.equals((Object)this.outputFormat, (Object)operationOcr.outputFormat) && Objects.equals(this.page, operationOcr.page) && Objects.equals(this.pdfa, operationOcr.pdfa);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkResolution, this.failOnWarning, this.forceEachPage, this.imageDpi, this.jpegQuality, this.language, this.normalizePageRotation, this.ocrMode, this.optimization, this.outputFormat, this.page, this.pdfa});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationOcr {\n");
        sb.append("    checkResolution: ").append(this.toIndentedString(this.checkResolution)).append("\n");
        sb.append("    failOnWarning: ").append(this.toIndentedString(this.failOnWarning)).append("\n");
        sb.append("    forceEachPage: ").append(this.toIndentedString(this.forceEachPage)).append("\n");
        sb.append("    imageDpi: ").append(this.toIndentedString(this.imageDpi)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    normalizePageRotation: ").append(this.toIndentedString(this.normalizePageRotation)).append("\n");
        sb.append("    ocrMode: ").append(this.toIndentedString((Object)this.ocrMode)).append("\n");
        sb.append("    optimization: ").append(this.toIndentedString(this.optimization)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString((Object)this.outputFormat)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pdfa: ").append(this.toIndentedString(this.pdfa)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OutputFormatEnum {
        TEXT("text"),
        HOCR("hocr"),
        PDF("pdf");

        private String value;

        private OutputFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutputFormatEnum fromValue(String value) {
            for (OutputFormatEnum b : OutputFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OcrModeEnum {
        PAGESEGMENTS("pageSegments"),
        COLUMN("column"),
        UNFILTERED("unfiltered");

        private String value;

        private OcrModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OcrModeEnum fromValue(String value) {
            for (OcrModeEnum b : OcrModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LanguageEnum {
        ENG("eng"),
        DEU("deu"),
        FRA("fra"),
        ITA("ita"),
        SPA("spa");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

