/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The optimization element allows to correct the images of the pages to optimize them for OCR. Except for the \"deskew\" parameter, none of the optimizations are actually visible in the generated documents. The other optimizations are only used to improve the text recognition.")
@JsonPropertyOrder(value={"deskew", "despeckle", "edgeAccentuation", "edgeAccentuationValue", "gammaCorrection", "gammaCorrectionValue", "increaseContrast", "increaseContrastValue", "medianFilter", "medianFilterValue", "noiseReduction", "noiseReductionValue", "reduceDithering", "sharpen", "sharpenValue"})
@JsonTypeName(value="Operation_ImageOptimization")
public class OperationImageOptimization {
    public static final String JSON_PROPERTY_DESKEW = "deskew";
    private Boolean deskew = true;
    public static final String JSON_PROPERTY_DESPECKLE = "despeckle";
    private Boolean despeckle = true;
    public static final String JSON_PROPERTY_EDGE_ACCENTUATION = "edgeAccentuation";
    private EdgeAccentuationEnum edgeAccentuation = EdgeAccentuationEnum.LOW;
    public static final String JSON_PROPERTY_EDGE_ACCENTUATION_VALUE = "edgeAccentuationValue";
    private Integer edgeAccentuationValue = 100;
    public static final String JSON_PROPERTY_GAMMA_CORRECTION = "gammaCorrection";
    private GammaCorrectionEnum gammaCorrection = GammaCorrectionEnum.OFF;
    public static final String JSON_PROPERTY_GAMMA_CORRECTION_VALUE = "gammaCorrectionValue";
    private Float gammaCorrectionValue = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_INCREASE_CONTRAST = "increaseContrast";
    private IncreaseContrastEnum increaseContrast = IncreaseContrastEnum.OFF;
    public static final String JSON_PROPERTY_INCREASE_CONTRAST_VALUE = "increaseContrastValue";
    private Integer increaseContrastValue = 0;
    public static final String JSON_PROPERTY_MEDIAN_FILTER = "medianFilter";
    private MedianFilterEnum medianFilter = MedianFilterEnum.LOW;
    public static final String JSON_PROPERTY_MEDIAN_FILTER_VALUE = "medianFilterValue";
    private Integer medianFilterValue = 1;
    public static final String JSON_PROPERTY_NOISE_REDUCTION = "noiseReduction";
    private NoiseReductionEnum noiseReduction = NoiseReductionEnum.LOW;
    public static final String JSON_PROPERTY_NOISE_REDUCTION_VALUE = "noiseReductionValue";
    private Float noiseReductionValue = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_REDUCE_DITHERING = "reduceDithering";
    private Boolean reduceDithering = false;
    public static final String JSON_PROPERTY_SHARPEN = "sharpen";
    private SharpenEnum sharpen = SharpenEnum.LOW;
    public static final String JSON_PROPERTY_SHARPEN_VALUE = "sharpenValue";
    private Float sharpenValue = Float.valueOf(1.0f);

    public OperationImageOptimization deskew(Boolean deskew) {
        this.deskew = deskew;
        return this;
    }

    @Schema(name="Straight scans of pages can be created with a slight skew. If this value is set to true, an attempt is made to counter-rotate this skew and thus \"deskew\" the page. The results of this manipulation are visible in the resulting document.")
    @JsonProperty(value="deskew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDeskew() {
        return this.deskew;
    }

    @JsonProperty(value="deskew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeskew(Boolean deskew) {
        this.deskew = deskew;
    }

    public OperationImageOptimization despeckle(Boolean despeckle) {
        this.despeckle = despeckle;
        return this;
    }

    @Schema(name="If this mode is set, impurities and stains are reduced. These are caused, for example, by dust or dirt on the pane of a scanner. It is recommended to activate this optimization.")
    @JsonProperty(value="despeckle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDespeckle() {
        return this.despeckle;
    }

    @JsonProperty(value="despeckle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDespeckle(Boolean despeckle) {
        this.despeckle = despeckle;
    }

    public OperationImageOptimization edgeAccentuation(EdgeAccentuationEnum edgeAccentuation) {
        this.edgeAccentuation = edgeAccentuation;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="edgeAccentuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public EdgeAccentuationEnum getEdgeAccentuation() {
        return this.edgeAccentuation;
    }

    @JsonProperty(value="edgeAccentuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEdgeAccentuation(EdgeAccentuationEnum edgeAccentuation) {
        this.edgeAccentuation = edgeAccentuation;
    }

    public OperationImageOptimization edgeAccentuationValue(Integer edgeAccentuationValue) {
        this.edgeAccentuationValue = edgeAccentuationValue;
        return this;
    }

    @Schema(name="Allows in combination with the edgeAccentuation mode \"value\" the free choice of a value for this optimization. An integer percentage value indicates the intensity of the edge accentuation. The actual image is overlaid with a corresponding sharpening filter for the edge accentuation - this percentage value specifies how intensively this effect should be emphasized compared to the original image. The predefined values range between 100 (low) and 200 percent (high).")
    @JsonProperty(value="edgeAccentuationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getEdgeAccentuationValue() {
        return this.edgeAccentuationValue;
    }

    @JsonProperty(value="edgeAccentuationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEdgeAccentuationValue(Integer edgeAccentuationValue) {
        this.edgeAccentuationValue = edgeAccentuationValue;
    }

    public OperationImageOptimization gammaCorrection(GammaCorrectionEnum gammaCorrection) {
        this.gammaCorrection = gammaCorrection;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="gammaCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public GammaCorrectionEnum getGammaCorrection() {
        return this.gammaCorrection;
    }

    @JsonProperty(value="gammaCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGammaCorrection(GammaCorrectionEnum gammaCorrection) {
        this.gammaCorrection = gammaCorrection;
    }

    public OperationImageOptimization gammaCorrectionValue(Float gammaCorrectionValue) {
        this.gammaCorrectionValue = gammaCorrectionValue;
        return this;
    }

    @Schema(name="Allows in combination with the gammaCorrection mode \"value\" the free choice of a value for this optimization. A comma value greater than 0 specifies the value to be applied to the image as gamma correction. The predefined values range between 1.5 (low) and 2.5 (high).")
    @JsonProperty(value="gammaCorrectionValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getGammaCorrectionValue() {
        return this.gammaCorrectionValue;
    }

    @JsonProperty(value="gammaCorrectionValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGammaCorrectionValue(Float gammaCorrectionValue) {
        this.gammaCorrectionValue = gammaCorrectionValue;
    }

    public OperationImageOptimization increaseContrast(IncreaseContrastEnum increaseContrast) {
        this.increaseContrast = increaseContrast;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="increaseContrast")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public IncreaseContrastEnum getIncreaseContrast() {
        return this.increaseContrast;
    }

    @JsonProperty(value="increaseContrast")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncreaseContrast(IncreaseContrastEnum increaseContrast) {
        this.increaseContrast = increaseContrast;
    }

    public OperationImageOptimization increaseContrastValue(Integer increaseContrastValue) {
        this.increaseContrastValue = increaseContrastValue;
        return this;
    }

    @Schema(name="Allows in combination with the increaseContrast mode \"value\" the free choice of a value for this optimization. An integer value between -100 and +100 specifies the intensity of the contrast enhancement. The predefined values range between 25 (low) and 75 (high).")
    @JsonProperty(value="increaseContrastValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getIncreaseContrastValue() {
        return this.increaseContrastValue;
    }

    @JsonProperty(value="increaseContrastValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncreaseContrastValue(Integer increaseContrastValue) {
        this.increaseContrastValue = increaseContrastValue;
    }

    public OperationImageOptimization medianFilter(MedianFilterEnum medianFilter) {
        this.medianFilter = medianFilter;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="medianFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MedianFilterEnum getMedianFilter() {
        return this.medianFilter;
    }

    @JsonProperty(value="medianFilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMedianFilter(MedianFilterEnum medianFilter) {
        this.medianFilter = medianFilter;
    }

    public OperationImageOptimization medianFilterValue(Integer medianFilterValue) {
        this.medianFilterValue = medianFilterValue;
        return this;
    }

    @Schema(name="Allows, in combination with the medianFilter mode \"value\", the free choice of a value for this optimization. An integer value greater than 0 specifies the grid size with which the effect is to be applied to the image. The predefined values range between 1 (low) and 3 (high).")
    @JsonProperty(value="medianFilterValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMedianFilterValue() {
        return this.medianFilterValue;
    }

    @JsonProperty(value="medianFilterValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMedianFilterValue(Integer medianFilterValue) {
        this.medianFilterValue = medianFilterValue;
    }

    public OperationImageOptimization noiseReduction(NoiseReductionEnum noiseReduction) {
        this.noiseReduction = noiseReduction;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="noiseReduction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NoiseReductionEnum getNoiseReduction() {
        return this.noiseReduction;
    }

    @JsonProperty(value="noiseReduction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNoiseReduction(NoiseReductionEnum noiseReduction) {
        this.noiseReduction = noiseReduction;
    }

    public OperationImageOptimization noiseReductionValue(Float noiseReductionValue) {
        this.noiseReductionValue = noiseReductionValue;
        return this;
    }

    @Schema(name="Allows in combination with the noiseReduction mode \"value\" the free choice of a value for this optimization. A decimal value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).")
    @JsonProperty(value="noiseReductionValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getNoiseReductionValue() {
        return this.noiseReductionValue;
    }

    @JsonProperty(value="noiseReductionValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNoiseReductionValue(Float noiseReductionValue) {
        this.noiseReductionValue = noiseReductionValue;
    }

    public OperationImageOptimization reduceDithering(Boolean reduceDithering) {
        this.reduceDithering = reduceDithering;
        return this;
    }

    @Schema(name="In black and white images (including black and white scans), color values are often represented by a halftone according to their brightness (dithering / moir\u00e9 effect). These halftones/hatchings translate a color value into a uniform sequence of black and white areas that visually appear to be a uniform area of the same color/brightness. Such patterns can be very difficult to delineate against actual text that may be in such a \"colored\" area. Setting this value to true will try to reduce such dithering patterns. This mode should only be set if absolutely necessary, as this process can be very lossy.")
    @JsonProperty(value="reduceDithering")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getReduceDithering() {
        return this.reduceDithering;
    }

    @JsonProperty(value="reduceDithering")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReduceDithering(Boolean reduceDithering) {
        this.reduceDithering = reduceDithering;
    }

    public OperationImageOptimization sharpen(SharpenEnum sharpen) {
        this.sharpen = sharpen;
        return this;
    }

    @Schema(name="If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
    @JsonProperty(value="sharpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SharpenEnum getSharpen() {
        return this.sharpen;
    }

    @JsonProperty(value="sharpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSharpen(SharpenEnum sharpen) {
        this.sharpen = sharpen;
    }

    public OperationImageOptimization sharpenValue(Float sharpenValue) {
        this.sharpenValue = sharpenValue;
        return this;
    }

    @Schema(name="Allows in combination with the sharpen mode \"value\" the free choice of a value for this optimization. A comma value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).")
    @JsonProperty(value="sharpenValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getSharpenValue() {
        return this.sharpenValue;
    }

    @JsonProperty(value="sharpenValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSharpenValue(Float sharpenValue) {
        this.sharpenValue = sharpenValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationImageOptimization operationImageOptimization = (OperationImageOptimization)o;
        return Objects.equals(this.deskew, operationImageOptimization.deskew) && Objects.equals(this.despeckle, operationImageOptimization.despeckle) && Objects.equals((Object)this.edgeAccentuation, (Object)operationImageOptimization.edgeAccentuation) && Objects.equals(this.edgeAccentuationValue, operationImageOptimization.edgeAccentuationValue) && Objects.equals((Object)this.gammaCorrection, (Object)operationImageOptimization.gammaCorrection) && Objects.equals(this.gammaCorrectionValue, operationImageOptimization.gammaCorrectionValue) && Objects.equals((Object)this.increaseContrast, (Object)operationImageOptimization.increaseContrast) && Objects.equals(this.increaseContrastValue, operationImageOptimization.increaseContrastValue) && Objects.equals((Object)this.medianFilter, (Object)operationImageOptimization.medianFilter) && Objects.equals(this.medianFilterValue, operationImageOptimization.medianFilterValue) && Objects.equals((Object)this.noiseReduction, (Object)operationImageOptimization.noiseReduction) && Objects.equals(this.noiseReductionValue, operationImageOptimization.noiseReductionValue) && Objects.equals(this.reduceDithering, operationImageOptimization.reduceDithering) && Objects.equals((Object)this.sharpen, (Object)operationImageOptimization.sharpen) && Objects.equals(this.sharpenValue, operationImageOptimization.sharpenValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deskew, this.despeckle, this.edgeAccentuation, this.edgeAccentuationValue, this.gammaCorrection, this.gammaCorrectionValue, this.increaseContrast, this.increaseContrastValue, this.medianFilter, this.medianFilterValue, this.noiseReduction, this.noiseReductionValue, this.reduceDithering, this.sharpen, this.sharpenValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationImageOptimization {\n");
        sb.append("    deskew: ").append(this.toIndentedString(this.deskew)).append("\n");
        sb.append("    despeckle: ").append(this.toIndentedString(this.despeckle)).append("\n");
        sb.append("    edgeAccentuation: ").append(this.toIndentedString((Object)this.edgeAccentuation)).append("\n");
        sb.append("    edgeAccentuationValue: ").append(this.toIndentedString(this.edgeAccentuationValue)).append("\n");
        sb.append("    gammaCorrection: ").append(this.toIndentedString((Object)this.gammaCorrection)).append("\n");
        sb.append("    gammaCorrectionValue: ").append(this.toIndentedString(this.gammaCorrectionValue)).append("\n");
        sb.append("    increaseContrast: ").append(this.toIndentedString((Object)this.increaseContrast)).append("\n");
        sb.append("    increaseContrastValue: ").append(this.toIndentedString(this.increaseContrastValue)).append("\n");
        sb.append("    medianFilter: ").append(this.toIndentedString((Object)this.medianFilter)).append("\n");
        sb.append("    medianFilterValue: ").append(this.toIndentedString(this.medianFilterValue)).append("\n");
        sb.append("    noiseReduction: ").append(this.toIndentedString((Object)this.noiseReduction)).append("\n");
        sb.append("    noiseReductionValue: ").append(this.toIndentedString(this.noiseReductionValue)).append("\n");
        sb.append("    reduceDithering: ").append(this.toIndentedString(this.reduceDithering)).append("\n");
        sb.append("    sharpen: ").append(this.toIndentedString((Object)this.sharpen)).append("\n");
        sb.append("    sharpenValue: ").append(this.toIndentedString(this.sharpenValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SharpenEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private SharpenEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SharpenEnum fromValue(String value) {
            for (SharpenEnum b : SharpenEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum NoiseReductionEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private NoiseReductionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NoiseReductionEnum fromValue(String value) {
            for (NoiseReductionEnum b : NoiseReductionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MedianFilterEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private MedianFilterEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MedianFilterEnum fromValue(String value) {
            for (MedianFilterEnum b : MedianFilterEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum IncreaseContrastEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private IncreaseContrastEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IncreaseContrastEnum fromValue(String value) {
            for (IncreaseContrastEnum b : IncreaseContrastEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum GammaCorrectionEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private GammaCorrectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GammaCorrectionEnum fromValue(String value) {
            for (GammaCorrectionEnum b : GammaCorrectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EdgeAccentuationEnum {
        OFF("off"),
        VALUE("value"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private EdgeAccentuationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EdgeAccentuationEnum fromValue(String value) {
            for (EdgeAccentuationEnum b : EdgeAccentuationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

