/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define the annotation element that should be linked to the file attachment.  **Important:** If an \"annotation element\" is not defined for the \"file element,\" the attachment will be stored at the document level.")
@JsonPropertyOrder(value={"color", "height", "icon", "lockedPosition", "opacity", "page", "point", "popupText", "width"})
@JsonTypeName(value="Operation_FileAnnotation")
public class OperationFileAnnotation {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_ICON = "icon";
    private IconEnum icon = IconEnum.PAPERCLIP;
    public static final String JSON_PROPERTY_LOCKED_POSITION = "lockedPosition";
    private Boolean lockedPosition = true;
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_POINT = "point";
    private OperationPoint point;
    public static final String JSON_PROPERTY_POPUP_TEXT = "popupText";
    private String popupText = "";
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width = Float.valueOf(0.0f);

    public OperationFileAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The annotation colour will change the main colour of the attachment's icon. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationFileAnnotation height(Float height) {
        this.height = height;
        return this;
    }

    @Schema(name="If this value is positive, the annotation will be generated with a fixed height corresponding to the value instead of using the dimensions of the specified icon.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public OperationFileAnnotation icon(IconEnum icon) {
        this.icon = icon;
        return this;
    }

    @Schema(name="If an attachment is embedded at the page level, this option can be used to specify the icon that should be used to show it:  The value you use here will define which icon will be used, as well as the basic dimensions for the annotation generated in the PDF. If you use the \"None\" icon type, a predefined icon will not be used. Instead, this option will only use the dimensions specified in \"width\" and \"height\" to generate an annotation with a transparent selection box at the specified position.  *   graph = Diagram *   paperclip = Paper clip *   pushPin = Thumb tack *   tag = Tag *   none = Rectangular selection box")
    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public IconEnum getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIcon(IconEnum icon) {
        this.icon = icon;
    }

    public OperationFileAnnotation lockedPosition(Boolean lockedPosition) {
        this.lockedPosition = lockedPosition;
        return this;
    }

    @Schema(name="If this value is set to \"true\", the person viewing the document will not be allowed to move the icon for the file attached at the page level.")
    @JsonProperty(value="lockedPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLockedPosition() {
        return this.lockedPosition;
    }

    @JsonProperty(value="lockedPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLockedPosition(Boolean lockedPosition) {
        this.lockedPosition = lockedPosition;
    }

    public OperationFileAnnotation opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="Used to set the opacity for the attachment's icon. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationFileAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Used to define the page on which the annotation will be generated, i.e., the page where the attachment will be stored.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationFileAnnotation point(OperationPoint point) {
        this.point = point;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationPoint getPoint() {
        return this.point;
    }

    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPoint(OperationPoint point) {
        this.point = point;
    }

    public OperationFileAnnotation popupText(String popupText) {
        this.popupText = popupText;
        return this;
    }

    @Schema(name="The text that should be displayed in the pop-up for the annotation.")
    @JsonProperty(value="popupText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPopupText() {
        return this.popupText;
    }

    @JsonProperty(value="popupText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopupText(String popupText) {
        this.popupText = popupText;
    }

    public OperationFileAnnotation width(Float width) {
        this.width = width;
        return this;
    }

    @Schema(name="If this value is positive, the annotation will be generated with a fixed width corresponding to the value instead of using the dimensions of the specified icon.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFileAnnotation operationFileAnnotation = (OperationFileAnnotation)o;
        return Objects.equals(this.color, operationFileAnnotation.color) && Objects.equals(this.height, operationFileAnnotation.height) && Objects.equals((Object)this.icon, (Object)operationFileAnnotation.icon) && Objects.equals(this.lockedPosition, operationFileAnnotation.lockedPosition) && Objects.equals(this.opacity, operationFileAnnotation.opacity) && Objects.equals(this.page, operationFileAnnotation.page) && Objects.equals(this.point, operationFileAnnotation.point) && Objects.equals(this.popupText, operationFileAnnotation.popupText) && Objects.equals(this.width, operationFileAnnotation.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.height, this.icon, this.lockedPosition, this.opacity, this.page, this.point, this.popupText, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFileAnnotation {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString((Object)this.icon)).append("\n");
        sb.append("    lockedPosition: ").append(this.toIndentedString(this.lockedPosition)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    point: ").append(this.toIndentedString(this.point)).append("\n");
        sb.append("    popupText: ").append(this.toIndentedString(this.popupText)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IconEnum {
        GRAPH("graph"),
        PAPERCLIP("paperclip"),
        PUSHPIN("pushPin"),
        TAG("tag"),
        NONE("none");

        private String value;

        private IconEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IconEnum fromValue(String value) {
            for (IconEnum b : IconEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

