/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="If you add another (optional) `<custom .../>` element to the description element, you can use it to store your own values in the PDF description. The element can occur multiple times and defines an additional entry for the description.")
@JsonPropertyOrder(value={"key", "remove", "value"})
@JsonTypeName(value="Operation_DescriptionCustom")
public class OperationDescriptionCustom {
    public static final String JSON_PROPERTY_KEY = "key";
    private String key = "";
    public static final String JSON_PROPERTY_REMOVE = "remove";
    private Boolean remove = false;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationDescriptionCustom key(String key) {
        this.key = key;
        return this;
    }

    @Schema(name="Describes the name of the field to be added to the PDF description. The value must not be empty, must be unique, and must not conflict with the other (default) field names (e.g. \"Subject\"). If a name conflict occurs, the entry will be skipped and not entered.")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKey(String key) {
        this.key = key;
    }

    public OperationDescriptionCustom remove(Boolean remove) {
        this.remove = remove;
        return this;
    }

    @Schema(name="If \"true\", then the field is not added but removed. In this case \"value\" has no meaning. If the field is not present, then the entry is skipped.")
    @JsonProperty(value="remove")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRemove() {
        return this.remove;
    }

    @JsonProperty(value="remove")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public OperationDescriptionCustom value(String value) {
        this.value = value;
        return this;
    }

    @Schema(name="Describes the value to be stored in the PDF description.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDescriptionCustom operationDescriptionCustom = (OperationDescriptionCustom)o;
        return Objects.equals(this.key, operationDescriptionCustom.key) && Objects.equals(this.remove, operationDescriptionCustom.remove) && Objects.equals(this.value, operationDescriptionCustom.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.remove, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationDescriptionCustom {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

