/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Allows the transfer of a certificate (as a PEM file), for the en-/decryption of an asymmetrically encrypted document. The certificate identifies the rights recipient who is to be given access to the document. The transfer of multiple certificates or other structures is not intended at this point; exactly one certificate is expected for the decryption of the document. The rights recipient must already be assigned to the document when the document is encrypted. The certificate and private key must therefore be selected in such a way that they map a rights recipient who was entered in this document when it was encrypted.")
@JsonPropertyOrder(value={"source", "uri", "value"})
@JsonTypeName(value="Operation_CertificateFileData")
public class OperationCertificateFileData {
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationCertificateFileData source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationCertificateFileData uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationCertificateFileData value(String value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationCertificateFileData operationCertificateFileData = (OperationCertificateFileData)o;
        return Objects.equals((Object)this.source, (Object)operationCertificateFileData.source) && Objects.equals(this.uri, operationCertificateFileData.uri) && Objects.equals(this.value, operationCertificateFileData.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.uri, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationCertificateFileData {\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        VALUE("value"),
        URI("uri");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

