/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a border for a rendered geometrical element.")
@JsonPropertyOrder(value={"borderStyle", "borderWidth", "dashLength", "gapLength"})
@JsonTypeName(value="Operation_Border")
public class OperationBorder {
    public static final String JSON_PROPERTY_BORDER_STYLE = "borderStyle";
    private BorderStyleEnum borderStyle = BorderStyleEnum.SOLID;
    public static final String JSON_PROPERTY_BORDER_WIDTH = "borderWidth";
    private Integer borderWidth = 1;
    public static final String JSON_PROPERTY_DASH_LENGTH = "dashLength";
    private Integer dashLength = 3;
    public static final String JSON_PROPERTY_GAP_LENGTH = "gapLength";
    private Integer gapLength = 3;

    public OperationBorder borderStyle(BorderStyleEnum borderStyle) {
        this.borderStyle = borderStyle;
        return this;
    }

    @Schema(name="Defines the border style.  *   solid = A solid line border. *   dashed = A dashed border using the given dash and gap length.")
    @JsonProperty(value="borderStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public BorderStyleEnum getBorderStyle() {
        return this.borderStyle;
    }

    @JsonProperty(value="borderStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBorderStyle(BorderStyleEnum borderStyle) {
        this.borderStyle = borderStyle;
    }

    public OperationBorder borderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @Schema(name="Defines the border width/strength/thickness.")
    @JsonProperty(value="borderWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    @JsonProperty(value="borderWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public OperationBorder dashLength(Integer dashLength) {
        this.dashLength = dashLength;
        return this;
    }

    @Schema(name="The interval length of dashes for a border with a \"dashed\" style.")
    @JsonProperty(value="dashLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDashLength() {
        return this.dashLength;
    }

    @JsonProperty(value="dashLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDashLength(Integer dashLength) {
        this.dashLength = dashLength;
    }

    public OperationBorder gapLength(Integer gapLength) {
        this.gapLength = gapLength;
        return this;
    }

    @Schema(name="The interval length of gaps for a border with a \"dashed\" style.")
    @JsonProperty(value="gapLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getGapLength() {
        return this.gapLength;
    }

    @JsonProperty(value="gapLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGapLength(Integer gapLength) {
        this.gapLength = gapLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationBorder operationBorder = (OperationBorder)o;
        return Objects.equals((Object)this.borderStyle, (Object)operationBorder.borderStyle) && Objects.equals(this.borderWidth, operationBorder.borderWidth) && Objects.equals(this.dashLength, operationBorder.dashLength) && Objects.equals(this.gapLength, operationBorder.gapLength);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.borderStyle, this.borderWidth, this.dashLength, this.gapLength});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationBorder {\n");
        sb.append("    borderStyle: ").append(this.toIndentedString((Object)this.borderStyle)).append("\n");
        sb.append("    borderWidth: ").append(this.toIndentedString(this.borderWidth)).append("\n");
        sb.append("    dashLength: ").append(this.toIndentedString(this.dashLength)).append("\n");
        sb.append("    gapLength: ").append(this.toIndentedString(this.gapLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BorderStyleEnum {
        SOLID("solid"),
        DASHED("dashed");

        private String value;

        private BorderStyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BorderStyleEnum fromValue(String value) {
            for (BorderStyleEnum b : BorderStyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

