/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataFont;
import net.webpdf.wsclient.openapi.MetadataFooterHeaderFooter;
import net.webpdf.wsclient.openapi.MetadataHeaderHeaderFooter;
import net.webpdf.wsclient.openapi.MetadataMargin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type defines header and footer values for a page of the document.")
@JsonPropertyOrder(value={"color", "font", "footer", "header", "margin", "objectKey", "page"})
@JsonTypeName(value="Metadata_HeaderFooter")
public class MetadataHeaderFooter {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "";
    public static final String JSON_PROPERTY_FONT = "font";
    private MetadataFont font;
    public static final String JSON_PROPERTY_FOOTER = "footer";
    private MetadataFooterHeaderFooter footer;
    public static final String JSON_PROPERTY_HEADER = "header";
    private MetadataHeaderHeaderFooter header;
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private MetadataMargin margin;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;

    public MetadataHeaderFooter color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The text of headers and footers color.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public MetadataHeaderFooter font(MetadataFont font) {
        this.font = font;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="font")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataFont getFont() {
        return this.font;
    }

    @JsonProperty(value="font")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFont(MetadataFont font) {
        this.font = font;
    }

    public MetadataHeaderFooter footer(MetadataFooterHeaderFooter footer) {
        this.footer = footer;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="footer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataFooterHeaderFooter getFooter() {
        return this.footer;
    }

    @JsonProperty(value="footer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFooter(MetadataFooterHeaderFooter footer) {
        this.footer = footer;
    }

    public MetadataHeaderFooter header(MetadataHeaderHeaderFooter header) {
        this.header = header;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="header")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataHeaderHeaderFooter getHeader() {
        return this.header;
    }

    @JsonProperty(value="header")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeader(MetadataHeaderHeaderFooter header) {
        this.header = header;
    }

    public MetadataHeaderFooter margin(MetadataMargin margin) {
        this.margin = margin;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataMargin getMargin() {
        return this.margin;
    }

    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMargin(MetadataMargin margin) {
        this.margin = margin;
    }

    public MetadataHeaderFooter objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the header/footer definition. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataHeaderFooter page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page headers/footers shall be defined for.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataHeaderFooter metadataHeaderFooter = (MetadataHeaderFooter)o;
        return Objects.equals(this.color, metadataHeaderFooter.color) && Objects.equals(this.font, metadataHeaderFooter.font) && Objects.equals(this.footer, metadataHeaderFooter.footer) && Objects.equals(this.header, metadataHeaderFooter.header) && Objects.equals(this.margin, metadataHeaderFooter.margin) && Objects.equals(this.objectKey, metadataHeaderFooter.objectKey) && Objects.equals(this.page, metadataHeaderFooter.page);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.font, this.footer, this.header, this.margin, this.objectKey, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataHeaderFooter {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.font)).append("\n");
        sb.append("    footer: ").append(this.toIndentedString(this.footer)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

