/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a font format for a displayable page content.")
@JsonPropertyOrder(value={"name", "size", "underline"})
@JsonTypeName(value="Metadata_Font")
public class MetadataFont {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_SIZE = "size";
    private Float size = Float.valueOf(10.0f);
    public static final String JSON_PROPERTY_UNDERLINE = "underline";
    private Boolean underline = false;

    public MetadataFont name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The name of the used font.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataFont size(Float size) {
        this.size = size;
        return this;
    }

    @Schema(name="The size of the font.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Float size) {
        this.size = size;
    }

    public MetadataFont underline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    @Schema(name="When set to true, the text shall be underlined.")
    @JsonProperty(value="underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUnderline() {
        return this.underline;
    }

    @JsonProperty(value="underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFont metadataFont = (MetadataFont)o;
        return Objects.equals(this.name, metadataFont.name) && Objects.equals(this.size, metadataFont.size) && Objects.equals(this.underline, metadataFont.underline);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size, this.underline);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataFont {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    underline: ").append(this.toIndentedString(this.underline)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

