/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataAnnotationsDocument;
import net.webpdf.wsclient.openapi.MetadataAttachmentsDocument;
import net.webpdf.wsclient.openapi.MetadataBackgroundsDocument;
import net.webpdf.wsclient.openapi.MetadataFoldersDocument;
import net.webpdf.wsclient.openapi.MetadataFormDocument;
import net.webpdf.wsclient.openapi.MetadataHeadersFootersDocument;
import net.webpdf.wsclient.openapi.MetadataImagesDocument;
import net.webpdf.wsclient.openapi.MetadataInformation;
import net.webpdf.wsclient.openapi.MetadataPagesDocument;
import net.webpdf.wsclient.openapi.MetadataSecurity;
import net.webpdf.wsclient.openapi.MetadataSignaturesDocument;
import net.webpdf.wsclient.openapi.MetadataTransitionsDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="A document element that describes the content and properties of the PDF document as metadata.")
@JsonPropertyOrder(value={"annotations", "attachments", "backgrounds", "folders", "form", "headersFooters", "images", "information", "pages", "security", "signatures", "transitions"})
@JsonTypeName(value="Metadata_Document")
public class MetadataDocument {
    public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
    private MetadataAnnotationsDocument annotations;
    public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
    private MetadataAttachmentsDocument attachments;
    public static final String JSON_PROPERTY_BACKGROUNDS = "backgrounds";
    private MetadataBackgroundsDocument backgrounds;
    public static final String JSON_PROPERTY_FOLDERS = "folders";
    private MetadataFoldersDocument folders;
    public static final String JSON_PROPERTY_FORM = "form";
    private MetadataFormDocument form;
    public static final String JSON_PROPERTY_HEADERS_FOOTERS = "headersFooters";
    private MetadataHeadersFootersDocument headersFooters;
    public static final String JSON_PROPERTY_IMAGES = "images";
    private MetadataImagesDocument images;
    public static final String JSON_PROPERTY_INFORMATION = "information";
    private MetadataInformation information;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private MetadataPagesDocument pages;
    public static final String JSON_PROPERTY_SECURITY = "security";
    private MetadataSecurity security;
    public static final String JSON_PROPERTY_SIGNATURES = "signatures";
    private MetadataSignaturesDocument signatures;
    public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
    private MetadataTransitionsDocument transitions;

    public MetadataDocument annotations(MetadataAnnotationsDocument annotations) {
        this.annotations = annotations;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataAnnotationsDocument getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnotations(MetadataAnnotationsDocument annotations) {
        this.annotations = annotations;
    }

    public MetadataDocument attachments(MetadataAttachmentsDocument attachments) {
        this.attachments = attachments;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataAttachmentsDocument getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(MetadataAttachmentsDocument attachments) {
        this.attachments = attachments;
    }

    public MetadataDocument backgrounds(MetadataBackgroundsDocument backgrounds) {
        this.backgrounds = backgrounds;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="backgrounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataBackgroundsDocument getBackgrounds() {
        return this.backgrounds;
    }

    @JsonProperty(value="backgrounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackgrounds(MetadataBackgroundsDocument backgrounds) {
        this.backgrounds = backgrounds;
    }

    public MetadataDocument folders(MetadataFoldersDocument folders) {
        this.folders = folders;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="folders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataFoldersDocument getFolders() {
        return this.folders;
    }

    @JsonProperty(value="folders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolders(MetadataFoldersDocument folders) {
        this.folders = folders;
    }

    public MetadataDocument form(MetadataFormDocument form) {
        this.form = form;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="form")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataFormDocument getForm() {
        return this.form;
    }

    @JsonProperty(value="form")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForm(MetadataFormDocument form) {
        this.form = form;
    }

    public MetadataDocument headersFooters(MetadataHeadersFootersDocument headersFooters) {
        this.headersFooters = headersFooters;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="headersFooters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataHeadersFootersDocument getHeadersFooters() {
        return this.headersFooters;
    }

    @JsonProperty(value="headersFooters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeadersFooters(MetadataHeadersFootersDocument headersFooters) {
        this.headersFooters = headersFooters;
    }

    public MetadataDocument images(MetadataImagesDocument images) {
        this.images = images;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataImagesDocument getImages() {
        return this.images;
    }

    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImages(MetadataImagesDocument images) {
        this.images = images;
    }

    public MetadataDocument information(MetadataInformation information) {
        this.information = information;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="information")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataInformation getInformation() {
        return this.information;
    }

    @JsonProperty(value="information")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInformation(MetadataInformation information) {
        this.information = information;
    }

    public MetadataDocument pages(MetadataPagesDocument pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataPagesDocument getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(MetadataPagesDocument pages) {
        this.pages = pages;
    }

    public MetadataDocument security(MetadataSecurity security) {
        this.security = security;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="security")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataSecurity getSecurity() {
        return this.security;
    }

    @JsonProperty(value="security")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecurity(MetadataSecurity security) {
        this.security = security;
    }

    public MetadataDocument signatures(MetadataSignaturesDocument signatures) {
        this.signatures = signatures;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="signatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataSignaturesDocument getSignatures() {
        return this.signatures;
    }

    @JsonProperty(value="signatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatures(MetadataSignaturesDocument signatures) {
        this.signatures = signatures;
    }

    public MetadataDocument transitions(MetadataTransitionsDocument transitions) {
        this.transitions = transitions;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataTransitionsDocument getTransitions() {
        return this.transitions;
    }

    @JsonProperty(value="transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransitions(MetadataTransitionsDocument transitions) {
        this.transitions = transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataDocument metadataDocument = (MetadataDocument)o;
        return Objects.equals(this.annotations, metadataDocument.annotations) && Objects.equals(this.attachments, metadataDocument.attachments) && Objects.equals(this.backgrounds, metadataDocument.backgrounds) && Objects.equals(this.folders, metadataDocument.folders) && Objects.equals(this.form, metadataDocument.form) && Objects.equals(this.headersFooters, metadataDocument.headersFooters) && Objects.equals(this.images, metadataDocument.images) && Objects.equals(this.information, metadataDocument.information) && Objects.equals(this.pages, metadataDocument.pages) && Objects.equals(this.security, metadataDocument.security) && Objects.equals(this.signatures, metadataDocument.signatures) && Objects.equals(this.transitions, metadataDocument.transitions);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.attachments, this.backgrounds, this.folders, this.form, this.headersFooters, this.images, this.information, this.pages, this.security, this.signatures, this.transitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataDocument {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    backgrounds: ").append(this.toIndentedString(this.backgrounds)).append("\n");
        sb.append("    folders: ").append(this.toIndentedString(this.folders)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("    headersFooters: ").append(this.toIndentedString(this.headersFooters)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    information: ").append(this.toIndentedString(this.information)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    security: ").append(this.toIndentedString(this.security)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

