/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentInfo;
import net.webpdf.wsclient.openapi.DocumentInfoFormField;
import net.webpdf.wsclient.openapi.WebserviceException;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides form information for the PDF document")
@JsonPropertyOrder(value={"acroFormFields", "error", "value"})
@JsonTypeName(value="Document_InfoForm")
@JsonIgnoreProperties(value={"infoType"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="infoType", visible=true)
public class DocumentInfoForm
extends DocumentInfo {
    public static final String JSON_PROPERTY_ACRO_FORM_FIELDS = "acroFormFields";
    private List<DocumentInfoFormField> acroFormFields = null;
    public static final String JSON_PROPERTY_ERROR = "error";
    private WebserviceException error;
    public static final String JSON_PROPERTY_VALUE = "value";
    private byte[] value;

    public DocumentInfoForm() {
    }

    @JsonCreator
    public DocumentInfoForm(@JsonProperty(value="acroFormFields") List<DocumentInfoFormField> acroFormFields, @JsonProperty(value="value") byte[] value) {
        this();
        this.acroFormFields = acroFormFields;
        this.value = value;
    }

    @Schema(name="All AcroForms fields with fully qualified name and, if XFA form, mapping to XFA template and XFA data.")
    @JsonProperty(value="acroFormFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<DocumentInfoFormField> getAcroFormFields() {
        return this.acroFormFields;
    }

    public DocumentInfoForm error(WebserviceException error) {
        this.error = error;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WebserviceException getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(WebserviceException error) {
        this.error = error;
    }

    @Schema(name="Requested content (BASE64 encoded)")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentInfoForm documentInfoForm = (DocumentInfoForm)o;
        return Objects.equals(this.acroFormFields, documentInfoForm.acroFormFields) && Objects.equals(this.error, documentInfoForm.error) && Arrays.equals(this.value, documentInfoForm.value) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acroFormFields, this.error, Arrays.hashCode(this.value), super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentInfoForm {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    acroFormFields: ").append(this.toIndentedString(this.acroFormFields)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

