/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a set of options specific for the \"Signature\" web service.")
@JsonPropertyOrder(value={"enabled", "instances", "maxLatency", "queueSize"})
@JsonTypeName(value="ApplicationConfig_SignatureWebservice")
public class ApplicationConfigSignatureWebservice {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_INSTANCES = "instances";
    private Integer instances = 2;
    public static final String JSON_PROPERTY_MAX_LATENCY = "maxLatency";
    private Integer maxLatency = 180;
    public static final String JSON_PROPERTY_QUEUE_SIZE = "queueSize";
    private Integer queueSize = 100;

    public ApplicationConfigSignatureWebservice enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, then the web service is activated.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigSignatureWebservice instances(Integer instances) {
        this.instances = instances;
        return this;
    }

    @Schema(name="Number of parallel instances (threads) for the web service. Defines the number of requests that can be executed in parallel before requests are queued.")
    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public ApplicationConfigSignatureWebservice maxLatency(Integer maxLatency) {
        this.maxLatency = maxLatency;
        return this;
    }

    @Schema(name="Maximum time in seconds allowed for the execution of a web service before the request is aborted. When time is expired the execution is aborted.")
    @JsonProperty(value="maxLatency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxLatency() {
        return this.maxLatency;
    }

    @JsonProperty(value="maxLatency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLatency(Integer maxLatency) {
        this.maxLatency = maxLatency;
    }

    public ApplicationConfigSignatureWebservice queueSize(Integer queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @Schema(name="Maximum number of waiting requests, before new requests are rejected. If there are more requests than free instances, they are placed in the queue. If this maximum value is reached, further requests are rejected directly.")
    @JsonProperty(value="queueSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty(value="queueSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigSignatureWebservice applicationConfigSignatureWebservice = (ApplicationConfigSignatureWebservice)o;
        return Objects.equals(this.enabled, applicationConfigSignatureWebservice.enabled) && Objects.equals(this.instances, applicationConfigSignatureWebservice.instances) && Objects.equals(this.maxLatency, applicationConfigSignatureWebservice.maxLatency) && Objects.equals(this.queueSize, applicationConfigSignatureWebservice.queueSize);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.instances, this.maxLatency, this.queueSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigSignatureWebservice {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    maxLatency: ").append(this.toIndentedString(this.maxLatency)).append("\n");
        sb.append("    queueSize: ").append(this.toIndentedString(this.queueSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

