/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ApplicationConfigProxyNonHost;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a proxy server that shall be known to and used by the server to access external resources.")
@JsonPropertyOrder(value={"host", "nonProxyHost", "password", "port", "scheme", "userName"})
@JsonTypeName(value="ApplicationConfig_Proxy")
public class ApplicationConfigProxy {
    public static final String JSON_PROPERTY_HOST = "host";
    private String host = "";
    public static final String JSON_PROPERTY_NON_PROXY_HOST = "nonProxyHost";
    private List<ApplicationConfigProxyNonHost> nonProxyHost = null;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 8080;
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private String scheme = "http";
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName = "";

    public ApplicationConfigProxy host(String host) {
        this.host = host;
        return this;
    }

    @Schema(name="The address of the proxy server.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public ApplicationConfigProxy nonProxyHost(List<ApplicationConfigProxyNonHost> nonProxyHost) {
        this.nonProxyHost = nonProxyHost;
        return this;
    }

    public ApplicationConfigProxy addNonProxyHostItem(ApplicationConfigProxyNonHost nonProxyHostItem) {
        if (this.nonProxyHost == null) {
            this.nonProxyHost = new ArrayList<ApplicationConfigProxyNonHost>();
        }
        this.nonProxyHost.add(nonProxyHostItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="nonProxyHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ApplicationConfigProxyNonHost> getNonProxyHost() {
        return this.nonProxyHost;
    }

    @JsonProperty(value="nonProxyHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNonProxyHost(List<ApplicationConfigProxyNonHost> nonProxyHost) {
        this.nonProxyHost = nonProxyHost;
    }

    public ApplicationConfigProxy password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password of the user required to authenticate with the proxy server.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public ApplicationConfigProxy port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port on which the proxy listens.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public ApplicationConfigProxy scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Schema(name="The scheme to access the proxy server (currently only \"http\" or \"https\" are allowed).")
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ApplicationConfigProxy userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(name="The name of the user required to authenticate with the proxy server.")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigProxy applicationConfigProxy = (ApplicationConfigProxy)o;
        return Objects.equals(this.host, applicationConfigProxy.host) && Objects.equals(this.nonProxyHost, applicationConfigProxy.nonProxyHost) && Objects.equals(this.password, applicationConfigProxy.password) && Objects.equals(this.port, applicationConfigProxy.port) && Objects.equals(this.scheme, applicationConfigProxy.scheme) && Objects.equals(this.userName, applicationConfigProxy.userName);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.nonProxyHost, this.password, this.port, this.scheme, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigProxy {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    nonProxyHost: ").append(this.toIndentedString(this.nonProxyHost)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

