/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the timeout settings related to authentication and session.")
@JsonPropertyOrder(value={"autoRefresh", "inactivity"})
@JsonTypeName(value="ApplicationConfig_PortalAuthTimeout")
public class ApplicationConfigPortalAuthTimeout {
    public static final String JSON_PROPERTY_AUTO_REFRESH = "autoRefresh";
    private Integer autoRefresh = 300;
    public static final String JSON_PROPERTY_INACTIVITY = "inactivity";
    private Integer inactivity = 60;

    public ApplicationConfigPortalAuthTimeout autoRefresh(Integer autoRefresh) {
        this.autoRefresh = autoRefresh;
        return this;
    }

    @Schema(name="Defines the time in seconds before the access token expires at which an auto-refresh is performed. The auto-refresh prevents the session from expiring and the access token from becoming unusable. If the user is considered inactive, then a dialog is displayed before the auto-refresh is executed. If the value is '0', then the auto-refresh is disabled, i.e. the session ends when the access token expires.")
    @JsonProperty(value="autoRefresh")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getAutoRefresh() {
        return this.autoRefresh;
    }

    @JsonProperty(value="autoRefresh")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoRefresh(Integer autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public ApplicationConfigPortalAuthTimeout inactivity(Integer inactivity) {
        this.inactivity = inactivity;
        return this;
    }

    @Schema(name="Defines the time in seconds after which a user should be considered inactive if no activity is detected in the portal. If the value is '0', then the detection is disabled, i.e. the user is never inactive.")
    @JsonProperty(value="inactivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getInactivity() {
        return this.inactivity;
    }

    @JsonProperty(value="inactivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInactivity(Integer inactivity) {
        this.inactivity = inactivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigPortalAuthTimeout applicationConfigPortalAuthTimeout = (ApplicationConfigPortalAuthTimeout)o;
        return Objects.equals(this.autoRefresh, applicationConfigPortalAuthTimeout.autoRefresh) && Objects.equals(this.inactivity, applicationConfigPortalAuthTimeout.inactivity);
    }

    public int hashCode() {
        return Objects.hash(this.autoRefresh, this.inactivity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigPortalAuthTimeout {\n");
        sb.append("    autoRefresh: ").append(this.toIndentedString(this.autoRefresh)).append("\n");
        sb.append("    inactivity: ").append(this.toIndentedString(this.inactivity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

