/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ApplicationConfigChromiumBridgeCommandLine;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for the Chromium bridge. The Chromium bridge is used for converting emails and HTML documents.")
@JsonPropertyOrder(value={"commandLine", "enabled", "headlessMode", "hostAddress", "noSandbox", "path", "port"})
@JsonTypeName(value="ApplicationConfig_ChromiumBridge")
public class ApplicationConfigChromiumBridge {
    public static final String JSON_PROPERTY_COMMAND_LINE = "commandLine";
    private ApplicationConfigChromiumBridgeCommandLine commandLine;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_HEADLESS_MODE = "headlessMode";
    private HeadlessModeEnum headlessMode = HeadlessModeEnum.NEW;
    public static final String JSON_PROPERTY_HOST_ADDRESS = "hostAddress";
    private String hostAddress = "localhost";
    public static final String JSON_PROPERTY_NO_SANDBOX = "noSandbox";
    private Boolean noSandbox = false;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 0;

    public ApplicationConfigChromiumBridge commandLine(ApplicationConfigChromiumBridgeCommandLine commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="commandLine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigChromiumBridgeCommandLine getCommandLine() {
        return this.commandLine;
    }

    @JsonProperty(value="commandLine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommandLine(ApplicationConfigChromiumBridgeCommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public ApplicationConfigChromiumBridge enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, then the Chromium bridge is activated.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigChromiumBridge headlessMode(HeadlessModeEnum headlessMode) {
        this.headlessMode = headlessMode;
        return this;
    }

    @Schema(name="Defines the different headless modes of the Chromium instance.  *   NEW = Uses the same code base for the Chromium headless instance as the normal non-headless browser. *   OLD = Uses the old code base for the Chromium headless instance, which is different from the non-headless browser")
    @JsonProperty(value="headlessMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public HeadlessModeEnum getHeadlessMode() {
        return this.headlessMode;
    }

    @JsonProperty(value="headlessMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeadlessMode(HeadlessModeEnum headlessMode) {
        this.headlessMode = headlessMode;
    }

    public ApplicationConfigChromiumBridge hostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    @Schema(name="The IP address on which Chromium should be reachable.")
    @JsonProperty(value="hostAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getHostAddress() {
        return this.hostAddress;
    }

    @JsonProperty(value="hostAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public ApplicationConfigChromiumBridge noSandbox(Boolean noSandbox) {
        this.noSandbox = noSandbox;
        return this;
    }

    @Schema(name="Sets this option whether the Chromium process should run in a sandbox or not.  **Important:** Be aware that running Chromium outside a sandbox can be a security risk. Proceed with caution!")
    @JsonProperty(value="noSandbox")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getNoSandbox() {
        return this.noSandbox;
    }

    @JsonProperty(value="noSandbox")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNoSandbox(Boolean noSandbox) {
        this.noSandbox = noSandbox;
    }

    public ApplicationConfigChromiumBridge path(String path) {
        this.path = path;
        return this;
    }

    @Schema(name="Sets a custom base path for the Chromium application.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public ApplicationConfigChromiumBridge port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port on which Chromium should listen for requests.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigChromiumBridge applicationConfigChromiumBridge = (ApplicationConfigChromiumBridge)o;
        return Objects.equals(this.commandLine, applicationConfigChromiumBridge.commandLine) && Objects.equals(this.enabled, applicationConfigChromiumBridge.enabled) && Objects.equals((Object)this.headlessMode, (Object)applicationConfigChromiumBridge.headlessMode) && Objects.equals(this.hostAddress, applicationConfigChromiumBridge.hostAddress) && Objects.equals(this.noSandbox, applicationConfigChromiumBridge.noSandbox) && Objects.equals(this.path, applicationConfigChromiumBridge.path) && Objects.equals(this.port, applicationConfigChromiumBridge.port);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commandLine, this.enabled, this.headlessMode, this.hostAddress, this.noSandbox, this.path, this.port});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigChromiumBridge {\n");
        sb.append("    commandLine: ").append(this.toIndentedString(this.commandLine)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    headlessMode: ").append(this.toIndentedString((Object)this.headlessMode)).append("\n");
        sb.append("    hostAddress: ").append(this.toIndentedString(this.hostAddress)).append("\n");
        sb.append("    noSandbox: ").append(this.toIndentedString(this.noSandbox)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HeadlessModeEnum {
        OLD("old"),
        NEW("new");

        private String value;

        private HeadlessModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HeadlessModeEnum fromValue(String value) {
            for (HeadlessModeEnum b : HeadlessModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

