
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows to change PDF reader specific settings and dialog defaults.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Whether these parameters actually have an effect, depends directly on their support in the application used to display the PDF.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Only few of those settings are actually "enforced" and most PDF readers will provide the viewer with the means to circumvent or even alter those settings.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ViewerPreferencesType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ViewerPreferencesType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="hideToolbar" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hideMenuBar" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hideWindowUI" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="fitWindow" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="centerWindow" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="displayDocTitle" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="nonFullScreenPageMode" type="{http://schema.webpdf.de/1.0/operation}NonFullScreenPageModeType" default="none" />
 *       <attribute name="textDirection" type="{http://schema.webpdf.de/1.0/operation}TextDirectionType" default="leftToRight" />
 *       <attribute name="viewArea" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="crop_box" />
 *       <attribute name="viewClip" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="crop_box" />
 *       <attribute name="printArea" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="crop_box" />
 *       <attribute name="printClip" type="{http://schema.webpdf.de/1.0/operation}PageBoxType" default="crop_box" />
 *       <attribute name="printScaling" type="{http://schema.webpdf.de/1.0/operation}PrintScaleType" default="readerDefault" />
 *       <attribute name="duplex" type="{http://schema.webpdf.de/1.0/operation}DuplexType" default="none" />
 *       <attribute name="printTraySelection" type="{http://schema.webpdf.de/1.0/operation}PrintTraySelectionType" default="readerDefault" />
 *       <attribute name="printPageRange" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="numCopies" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ViewerPreferencesType")
public class ViewerPreferencesType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the toolbars of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideToolbar")
    protected Boolean hideToolbar;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the menu bars of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideMenuBar")
    protected Boolean hideMenuBar;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the scrollbars and other navigation features of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "hideWindowUI")
    protected Boolean hideWindowUI;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the window size of the PDF reader will be tried to fit the first page of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fitWindow")
    protected Boolean fitWindow;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the PDF reader window is moved to the center of the screen.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "centerWindow")
    protected Boolean centerWindow;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the document title of the document is displayed in the title bar of the PDF reader instead of the file name.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "displayDocTitle")
    protected Boolean displayDocTitle;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Configures the display of the document when the document is not viewed in full screen mode. This primarily configures which navigation view should be opened for the viewer.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = Neither the content overview nor the thumbnail of the pages should be displayed.&lt;/li&gt;&lt;li&gt;outlines = The content overview of the document should be displayed.&lt;/li&gt;&lt;li&gt;thumbnails = The thumbnail view of the pages of the document should be displayed.&lt;/li&gt;&lt;li&gt;optionalContents = The layers (Optional Content Groups) of the document should be displayed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "nonFullScreenPageMode")
    protected NonFullScreenPageModeType nonFullScreenPageMode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the text reading direction for the PDF reader's read aloud.&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right.&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "textDirection")
    protected TextDirectionType textDirection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to determine the displayed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus bleed frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewArea")
    protected PageBoxType viewArea;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to use for this document to crop the displayed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus crop frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "viewClip")
    protected PageBoxType viewClip;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to determine the printed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus bleed frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printArea")
    protected PageBoxType printArea;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to crop the printed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus crop frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printClip")
    protected PageBoxType printClip;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page&#13;
     *                         &lt;ul&gt;&lt;li&gt;scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time).&lt;/li&gt;&lt;li&gt;readerDefault = Use the scaling functions provided by the display program.&lt;/li&gt;&lt;li&gt;noPrintScaling = Do no page scaling and print the pages in original size.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printScaling")
    protected PrintScaleType printScaling;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).&#13;
     *                         &lt;ul&gt;&lt;li&gt;simplex = Print on one side.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = Print on both sides and flip over the longer edge of the page.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = Print on both sides and flip over the shorter side edge.&lt;/li&gt;&lt;li&gt;none = Use the default settings of the display program.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "duplex")
    protected DuplexType duplex;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = Use the default settings of the display program.&lt;/li&gt;&lt;li&gt;byPDFSize = Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printTraySelection")
    protected PrintTraySelectionType printTraySelection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) to print. For the page number, either a single page, a range of pages or a list (separated by commas) can be specified (e.g. "1,5-6,9"). The specification of all pages is done with "*". (This setting is only a dialog default and can be changed by the user at any time).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printPageRange")
    protected String printPageRange;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies how many copies of the document are to be printed. (This setting is only a dialog default and can be changed by the user at any time).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "numCopies")
    protected Integer numCopies;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the toolbars of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideToolbar() {
        if (hideToolbar == null) {
            return false;
        } else {
            return hideToolbar;
        }
    }

    /**
     * Sets the value of the hideToolbar property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideToolbar()
     */
    public void setHideToolbar(boolean value) {
        this.hideToolbar = value;
    }

    public boolean isSetHideToolbar() {
        return (this.hideToolbar!= null);
    }

    public void unsetHideToolbar() {
        this.hideToolbar = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the menu bars of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideMenuBar() {
        if (hideMenuBar == null) {
            return false;
        } else {
            return hideMenuBar;
        }
    }

    /**
     * Sets the value of the hideMenuBar property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideMenuBar()
     */
    public void setHideMenuBar(boolean value) {
        this.hideMenuBar = value;
    }

    public boolean isSetHideMenuBar() {
        return (this.hideMenuBar!= null);
    }

    public void unsetHideMenuBar() {
        this.hideMenuBar = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the scrollbars and other navigation features of the PDF reader are hidden for the display of this document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHideWindowUI() {
        if (hideWindowUI == null) {
            return false;
        } else {
            return hideWindowUI;
        }
    }

    /**
     * Sets the value of the hideWindowUI property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHideWindowUI()
     */
    public void setHideWindowUI(boolean value) {
        this.hideWindowUI = value;
    }

    public boolean isSetHideWindowUI() {
        return (this.hideWindowUI!= null);
    }

    public void unsetHideWindowUI() {
        this.hideWindowUI = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the window size of the PDF reader will be tried to fit the first page of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFitWindow() {
        if (fitWindow == null) {
            return false;
        } else {
            return fitWindow;
        }
    }

    /**
     * Sets the value of the fitWindow property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFitWindow()
     */
    public void setFitWindow(boolean value) {
        this.fitWindow = value;
    }

    public boolean isSetFitWindow() {
        return (this.fitWindow!= null);
    }

    public void unsetFitWindow() {
        this.fitWindow = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the PDF reader window is moved to the center of the screen.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCenterWindow() {
        if (centerWindow == null) {
            return false;
        } else {
            return centerWindow;
        }
    }

    /**
     * Sets the value of the centerWindow property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCenterWindow()
     */
    public void setCenterWindow(boolean value) {
        this.centerWindow = value;
    }

    public boolean isSetCenterWindow() {
        return (this.centerWindow!= null);
    }

    public void unsetCenterWindow() {
        this.centerWindow = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the document title of the document is displayed in the title bar of the PDF reader instead of the file name.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDisplayDocTitle() {
        if (displayDocTitle == null) {
            return false;
        } else {
            return displayDocTitle;
        }
    }

    /**
     * Sets the value of the displayDocTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isDisplayDocTitle()
     */
    public void setDisplayDocTitle(boolean value) {
        this.displayDocTitle = value;
    }

    public boolean isSetDisplayDocTitle() {
        return (this.displayDocTitle!= null);
    }

    public void unsetDisplayDocTitle() {
        this.displayDocTitle = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Configures the display of the document when the document is not viewed in full screen mode. This primarily configures which navigation view should be opened for the viewer.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = Neither the content overview nor the thumbnail of the pages should be displayed.&lt;/li&gt;&lt;li&gt;outlines = The content overview of the document should be displayed.&lt;/li&gt;&lt;li&gt;thumbnails = The thumbnail view of the pages of the document should be displayed.&lt;/li&gt;&lt;li&gt;optionalContents = The layers (Optional Content Groups) of the document should be displayed.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NonFullScreenPageModeType }
     *     
     */
    public NonFullScreenPageModeType getNonFullScreenPageMode() {
        if (nonFullScreenPageMode == null) {
            return NonFullScreenPageModeType.NONE;
        } else {
            return nonFullScreenPageMode;
        }
    }

    /**
     * Sets the value of the nonFullScreenPageMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link NonFullScreenPageModeType }
     *     
     * @see #getNonFullScreenPageMode()
     */
    public void setNonFullScreenPageMode(NonFullScreenPageModeType value) {
        this.nonFullScreenPageMode = value;
    }

    public boolean isSetNonFullScreenPageMode() {
        return (this.nonFullScreenPageMode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the text reading direction for the PDF reader's read aloud.&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right.&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TextDirectionType }
     *     
     */
    public TextDirectionType getTextDirection() {
        if (textDirection == null) {
            return TextDirectionType.LEFT_TO_RIGHT;
        } else {
            return textDirection;
        }
    }

    /**
     * Sets the value of the textDirection property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextDirectionType }
     *     
     * @see #getTextDirection()
     */
    public void setTextDirection(TextDirectionType value) {
        this.textDirection = value;
    }

    public boolean isSetTextDirection() {
        return (this.textDirection!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to determine the displayed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus bleed frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getViewArea() {
        if (viewArea == null) {
            return PageBoxType.CROP_BOX;
        } else {
            return viewArea;
        }
    }

    /**
     * Sets the value of the viewArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getViewArea()
     */
    public void setViewArea(PageBoxType value) {
        this.viewArea = value;
    }

    public boolean isSetViewArea() {
        return (this.viewArea!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to use for this document to crop the displayed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus crop frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getViewClip() {
        if (viewClip == null) {
            return PageBoxType.CROP_BOX;
        } else {
            return viewClip;
        }
    }

    /**
     * Sets the value of the viewClip property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getViewClip()
     */
    public void setViewClip(PageBoxType value) {
        this.viewClip = value;
    }

    public boolean isSetViewClip() {
        return (this.viewClip!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to determine the printed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus bleed frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getPrintArea() {
        if (printArea == null) {
            return PageBoxType.CROP_BOX;
        } else {
            return printArea;
        }
    }

    /**
     * Sets the value of the printArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getPrintArea()
     */
    public void setPrintArea(PageBoxType value) {
        this.printArea = value;
    }

    public boolean isSetPrintArea() {
        return (this.printArea!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page frame to be used for this document to crop the printed area. (Most PDF readers will not take this setting into account).&#13;
     *                         &lt;ul&gt;&lt;li&gt;media_box = The physical dimensions of the page.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus crop frame).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Special page content position (graphics).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageBoxType }
     *     
     */
    public PageBoxType getPrintClip() {
        if (printClip == null) {
            return PageBoxType.CROP_BOX;
        } else {
            return printClip;
        }
    }

    /**
     * Sets the value of the printClip property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageBoxType }
     *     
     * @see #getPrintClip()
     */
    public void setPrintClip(PageBoxType value) {
        this.printClip = value;
    }

    public boolean isSetPrintClip() {
        return (this.printClip!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page&#13;
     *                         &lt;ul&gt;&lt;li&gt;scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time).&lt;/li&gt;&lt;li&gt;readerDefault = Use the scaling functions provided by the display program.&lt;/li&gt;&lt;li&gt;noPrintScaling = Do no page scaling and print the pages in original size.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrintScaleType }
     *     
     */
    public PrintScaleType getPrintScaling() {
        if (printScaling == null) {
            return PrintScaleType.READER_DEFAULT;
        } else {
            return printScaling;
        }
    }

    /**
     * Sets the value of the printScaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintScaleType }
     *     
     * @see #getPrintScaling()
     */
    public void setPrintScaling(PrintScaleType value) {
        this.printScaling = value;
    }

    public boolean isSetPrintScaling() {
        return (this.printScaling!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).&#13;
     *                         &lt;ul&gt;&lt;li&gt;simplex = Print on one side.&lt;/li&gt;&lt;li&gt;duplexFlipLongEdge = Print on both sides and flip over the longer edge of the page.&lt;/li&gt;&lt;li&gt;duplexFlipShortEdge = Print on both sides and flip over the shorter side edge.&lt;/li&gt;&lt;li&gt;none = Use the default settings of the display program.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DuplexType }
     *     
     */
    public DuplexType getDuplex() {
        if (duplex == null) {
            return DuplexType.NONE;
        } else {
            return duplex;
        }
    }

    /**
     * Sets the value of the duplex property.
     * 
     * @param value
     *     allowed object is
     *     {@link DuplexType }
     *     
     * @see #getDuplex()
     */
    public void setDuplex(DuplexType value) {
        this.duplex = value;
    }

    public boolean isSetDuplex() {
        return (this.duplex!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).&#13;
     *                         &lt;ul&gt;&lt;li&gt;readerDefault = Use the default settings of the display program.&lt;/li&gt;&lt;li&gt;byPDFSize = Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrintTraySelectionType }
     *     
     */
    public PrintTraySelectionType getPrintTraySelection() {
        if (printTraySelection == null) {
            return PrintTraySelectionType.READER_DEFAULT;
        } else {
            return printTraySelection;
        }
    }

    /**
     * Sets the value of the printTraySelection property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintTraySelectionType }
     *     
     * @see #getPrintTraySelection()
     */
    public void setPrintTraySelection(PrintTraySelectionType value) {
        this.printTraySelection = value;
    }

    public boolean isSetPrintTraySelection() {
        return (this.printTraySelection!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies which page(s) to print. For the page number, either a single page, a range of pages or a list (separated by commas) can be specified (e.g. "1,5-6,9"). The specification of all pages is done with "*". (This setting is only a dialog default and can be changed by the user at any time).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrintPageRange() {
        if (printPageRange == null) {
            return "";
        } else {
            return printPageRange;
        }
    }

    /**
     * Sets the value of the printPageRange property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPrintPageRange()
     */
    public void setPrintPageRange(String value) {
        this.printPageRange = value;
    }

    public boolean isSetPrintPageRange() {
        return (this.printPageRange!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p416162_="https://jakarta.ee/xml/ns/jaxb" xmlns:p761379_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p931522_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies how many copies of the document are to be printed. (This setting is only a dialog default and can be changed by the user at any time).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getNumCopies() {
        if (numCopies == null) {
            return  1;
        } else {
            return numCopies;
        }
    }

    /**
     * Sets the value of the numCopies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getNumCopies()
     */
    public void setNumCopies(int value) {
        this.numCopies = value;
    }

    public boolean isSetNumCopies() {
        return (this.numCopies!= null);
    }

    public void unsetNumCopies() {
        this.numCopies = null;
    }

}
