
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The setTransition action shows the changes that result from the actions with the use of the defined transition animation.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TransitionActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransitionActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <attribute name="scaling" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="effectDimensionHorizontal" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="motionInward" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="flyAreaOpaque" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="flyScale" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="6400"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="direction" type="{http://schema.webpdf.de/1.0/operation}OutlineTransitionDirectionType" default="leftToRight" />
 *       <attribute name="style" type="{http://schema.webpdf.de/1.0/operation}OutlineTransitionStyleType" default="none" />
 *       <attribute name="duration" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransitionActionType")
public class TransitionActionType
    extends ActionEventType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the value for zooming (as a percentage).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "scaling")
    protected Integer scaling;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the split and blinds animation styles - used to define the axis along which the effect should happen. true corresponds to the horizontal axis; false to the vertical one.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "effectDimensionHorizontal")
    protected Boolean effectDimensionHorizontal;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the split, box, and fly animation styles - defines whether the animation direction will be from the edges of the page towards the centre (true) or from the centre towards the edges (false).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "motionInward")
    protected Boolean motionInward;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define whether the page background for the page that flies in should be transparent initially.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyAreaOpaque")
    protected Boolean flyAreaOpaque;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed (defined as a percentage).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyScale")
    protected Integer flyScale;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                                 &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "direction")
    protected OutlineTransitionDirectionType direction;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "style")
    protected OutlineTransitionStyleType style;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommended.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "duration")
    protected Float duration;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the value for zooming (as a percentage).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getScaling() {
        if (scaling == null) {
            return  100;
        } else {
            return scaling;
        }
    }

    /**
     * Sets the value of the scaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getScaling()
     */
    public void setScaling(int value) {
        this.scaling = value;
    }

    public boolean isSetScaling() {
        return (this.scaling!= null);
    }

    public void unsetScaling() {
        this.scaling = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the split and blinds animation styles - used to define the axis along which the effect should happen. true corresponds to the horizontal axis; false to the vertical one.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEffectDimensionHorizontal() {
        if (effectDimensionHorizontal == null) {
            return true;
        } else {
            return effectDimensionHorizontal;
        }
    }

    /**
     * Sets the value of the effectDimensionHorizontal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEffectDimensionHorizontal()
     */
    public void setEffectDimensionHorizontal(boolean value) {
        this.effectDimensionHorizontal = value;
    }

    public boolean isSetEffectDimensionHorizontal() {
        return (this.effectDimensionHorizontal!= null);
    }

    public void unsetEffectDimensionHorizontal() {
        this.effectDimensionHorizontal = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the split, box, and fly animation styles - defines whether the animation direction will be from the edges of the page towards the centre (true) or from the centre towards the edges (false).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMotionInward() {
        if (motionInward == null) {
            return true;
        } else {
            return motionInward;
        }
    }

    /**
     * Sets the value of the motionInward property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMotionInward()
     */
    public void setMotionInward(boolean value) {
        this.motionInward = value;
    }

    public boolean isSetMotionInward() {
        return (this.motionInward!= null);
    }

    public void unsetMotionInward() {
        this.motionInward = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define whether the page background for the page that flies in should be transparent initially.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFlyAreaOpaque() {
        if (flyAreaOpaque == null) {
            return false;
        } else {
            return flyAreaOpaque;
        }
    }

    /**
     * Sets the value of the flyAreaOpaque property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFlyAreaOpaque()
     */
    public void setFlyAreaOpaque(boolean value) {
        this.flyAreaOpaque = value;
    }

    public boolean isSetFlyAreaOpaque() {
        return (this.flyAreaOpaque!= null);
    }

    public void unsetFlyAreaOpaque() {
        this.flyAreaOpaque = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed (defined as a percentage).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getFlyScale() {
        if (flyScale == null) {
            return  100;
        } else {
            return flyScale;
        }
    }

    /**
     * Sets the value of the flyScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getFlyScale()
     */
    public void setFlyScale(int value) {
        this.flyScale = value;
    }

    public boolean isSetFlyScale() {
        return (this.flyScale!= null);
    }

    public void unsetFlyScale() {
        this.flyScale = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                                 &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OutlineTransitionDirectionType }
     *     
     */
    public OutlineTransitionDirectionType getDirection() {
        if (direction == null) {
            return OutlineTransitionDirectionType.LEFT_TO_RIGHT;
        } else {
            return direction;
        }
    }

    /**
     * Sets the value of the direction property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlineTransitionDirectionType }
     *     
     * @see #getDirection()
     */
    public void setDirection(OutlineTransitionDirectionType value) {
        this.direction = value;
    }

    public boolean isSetDirection() {
        return (this.direction!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OutlineTransitionStyleType }
     *     
     */
    public OutlineTransitionStyleType getStyle() {
        if (style == null) {
            return OutlineTransitionStyleType.NONE;
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlineTransitionStyleType }
     *     
     * @see #getStyle()
     */
    public void setStyle(OutlineTransitionStyleType value) {
        this.style = value;
    }

    public boolean isSetStyle() {
        return (this.style!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommended.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getDuration() {
        if (duration == null) {
            return  1.0F;
        } else {
            return duration;
        }
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getDuration()
     */
    public void setDuration(float value) {
        this.duration = value;
    }

    public boolean isSetDuration() {
        return (this.duration!= null);
    }

    public void unsetDuration() {
        this.duration = null;
    }

}
