
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to define settings for file formats for which a template is required for conversion. As of this writing, these settings apply to the following file formats:&#13;
 *                     &lt;ul&gt;&lt;li&gt;MIME mail (eml)&lt;/li&gt;&lt;li&gt;Outlook message (msg)&lt;/li&gt;&lt;li&gt;iCalendar (ics) / vCalendar (vcs)&lt;/li&gt;&lt;li&gt;vCard (vcf)&lt;/li&gt;&lt;li&gt;Serial Vector Format (svg)&lt;/li&gt;&lt;li&gt;Text document (txt)&lt;/li&gt;&lt;/ul&gt;&#13;
 * &#13;
 *                     In addition, you can replace the default template with a custom template of your own in "file". You can also use your own variables in this custom template. These variables would then need to be passed with a JSON structure (Base64-encoded) in "data".&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TemplateType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TemplateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="file" type="{http://schema.webpdf.de/1.0/operation}TemplateFileType" minOccurs="0"/>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}TemplateDataType" minOccurs="0"/>
 *       </all>
 *       <attribute name="language" type="{http://schema.webpdf.de/1.0/operation}LanguageType" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TemplateType", propOrder = {

})
@XmlSeeAlso({
    ConverterTemplateType.class
})
public class TemplateType {

    protected TemplateFileType file;
    protected TemplateDataType data;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An ISO 639-1-compliant language code consisting of 2 letters. If there is one, a localized template will be selected using the language selected here. If not defined, the language in which webPDF is run will be used.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String language;

    /**
     * Gets the value of the file property.
     * 
     * @return
     *     possible object is
     *     {@link TemplateFileType }
     *     
     */
    public TemplateFileType getFile() {
        return file;
    }

    /**
     * Sets the value of the file property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemplateFileType }
     *     
     */
    public void setFile(TemplateFileType value) {
        this.file = value;
    }

    public boolean isSetFile() {
        return (this.file!= null);
    }

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link TemplateDataType }
     *     
     */
    public TemplateDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemplateDataType }
     *     
     */
    public void setData(TemplateDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An ISO 639-1-compliant language code consisting of 2 letters. If there is one, a localized template will be selected using the language selected here. If not defined, the language in which webPDF is run will be used.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        return language;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }

}
