
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This element is used to configure language detection and the representation of syntax elements in recognized programming/script languages.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SyntaxHighlightType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SyntaxHighlightType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="fontSize" type="{http://www.w3.org/2001/XMLSchema}string" default="10px" />
 *       <attribute name="fontOrigin" type="{http://schema.webpdf.de/1.0/operation}FontOriginModeType" default="system" />
 *       <attribute name="fontFamily" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="wordBreak" type="{http://schema.webpdf.de/1.0/operation}TextWrapModeType" default="auto" />
 *       <attribute name="lineNumbers" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="lineHeight" type="{http://www.w3.org/2001/XMLSchema}string" default="12px" />
 *       <attribute name="language" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="available" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="relevance" type="{http://www.w3.org/2001/XMLSchema}int" default="90" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SyntaxHighlightType")
public class SyntaxHighlightType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font size for syntax highlighting to the specified value.&#13;
     *                         You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontSize")
    protected String fontSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected font should be obtained from your operating system or from the "templates/fonts" folder (in your webPDF installation path).&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;system = It will be possible to select from the fonts available system-wide.&lt;/li&gt;&lt;li&gt;folder =It will be possible to select from the fonts in "templates/fonts".&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontOrigin")
    protected FontOriginModeType fontOrigin;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the font that should be used for syntax highlighting. If you select "folder" for the "fontOrigin" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the "Fira Code" font will be used automatically.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fontFamily")
    protected String fontFamily;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to configure the word wrap behaviour during highlighting&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;auto = Automatic word wrap if necessary.&lt;/li&gt;&lt;li&gt;none = Suppress the addition of extra line breaks.&lt;/li&gt;&lt;li&gt;word = Line breaks allowed only after words.&lt;/li&gt;&lt;li&gt;all = Line breaks allowed unconditionally.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "wordBreak")
    protected TextWrapModeType wordBreak;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", line numbers are added before the code.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "lineNumbers")
    protected Boolean lineNumbers;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the line height. You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "lineHeight")
    protected String lineHeight;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select a specific language for highlighting recognition. You can select one of the languages listed for the "available" parameter. If you do not set this value, the system will attempt to automatically select an appropriate language from the list of available languages.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    protected String language;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to specify the languages to which the syntax highlighted should be limited. You can enter multiple languages by separating them with a comma ("java,cpp"). If you do not specify a value, all the languages listed below will be recognized.&#13;
     *                         You can select any of the following languages:&#13;
     *                         &lt;ul&gt;&lt;li&gt;abnf = Augmented Backus-Naur form&lt;/li&gt;&lt;li&gt;accesslog = Apache/Nginx Access Logs&lt;/li&gt;&lt;li&gt;actionscript = ActionScript&lt;/li&gt;&lt;li&gt;ada = Ada&lt;/li&gt;&lt;li&gt;angelscript = AngelScript&lt;/li&gt;&lt;li&gt;apache = Apache configuration language&lt;/li&gt;&lt;li&gt;applescript = AppleScript&lt;/li&gt;&lt;li&gt;arcade = ArcGIS Arcade&lt;/li&gt;&lt;li&gt;arduino = Arduino&lt;/li&gt;&lt;li&gt;armasm = ARM Assembly&lt;/li&gt;&lt;li&gt;asciidoc = AsciiDoc&lt;/li&gt;&lt;li&gt;aspectj = AspectJ&lt;/li&gt;&lt;li&gt;autohotkey = AutoHotkey&lt;/li&gt;&lt;li&gt;autoit = AutoIt&lt;/li&gt;&lt;li&gt;avrasm = AVR Assembler&lt;/li&gt;&lt;li&gt;awk = Awk&lt;/li&gt;&lt;li&gt;axapta = Axapta&lt;/li&gt;&lt;li&gt;bash = Bash&lt;/li&gt;&lt;li&gt;basic = Basic&lt;/li&gt;&lt;li&gt;bnf = Backus-Naur Form&lt;/li&gt;&lt;li&gt;brainfuck = Brainfuck&lt;/li&gt;&lt;li&gt;cal = C/AL&lt;/li&gt;&lt;li&gt;capnproto = Cap'n Proto&lt;/li&gt;&lt;li&gt;ceylon = Ceylon&lt;/li&gt;&lt;li&gt;clean = Clean&lt;/li&gt;&lt;li&gt;clojure-repl = Clojure REPL&lt;/li&gt;&lt;li&gt;clojure = Clojure&lt;/li&gt;&lt;li&gt;cmake = CMake&lt;/li&gt;&lt;li&gt;coffeescript = CoffeeScript&lt;/li&gt;&lt;li&gt;coq = Coq&lt;/li&gt;&lt;li&gt;cos = Caché Object Script&lt;/li&gt;&lt;li&gt;cpp = C++&lt;/li&gt;&lt;li&gt;crmsh = crmsh&lt;/li&gt;&lt;li&gt;crystal = Crystal&lt;/li&gt;&lt;li&gt;cs = C#&lt;/li&gt;&lt;li&gt;csp = CSP&lt;/li&gt;&lt;li&gt;css = CSS&lt;/li&gt;&lt;li&gt;d = D&lt;/li&gt;&lt;li&gt;dart = Dart&lt;/li&gt;&lt;li&gt;delphi = Delphi&lt;/li&gt;&lt;li&gt;diff = Diff&lt;/li&gt;&lt;li&gt;django = Django&lt;/li&gt;&lt;li&gt;dns = DNS Zone file&lt;/li&gt;&lt;li&gt;dockerfile = Dockerfile&lt;/li&gt;&lt;li&gt;dos = DOS .bat&lt;/li&gt;&lt;li&gt;dsconfig = dsconfig&lt;/li&gt;&lt;li&gt;dts = Device Tree&lt;/li&gt;&lt;li&gt;dust = Dust&lt;/li&gt;&lt;li&gt;ebnf = Extended Backus-Naur Form&lt;/li&gt;&lt;li&gt;elixir = Elixir&lt;/li&gt;&lt;li&gt;elm = Elm&lt;/li&gt;&lt;li&gt;erb = Embedded Ruby&lt;/li&gt;&lt;li&gt;erlang-repl = Erlang REPL&lt;/li&gt;&lt;li&gt;erlang = Erlang&lt;/li&gt;&lt;li&gt;excel = Excel&lt;/li&gt;&lt;li&gt;fix = FIX&lt;/li&gt;&lt;li&gt;flix = FLIX&lt;/li&gt;&lt;li&gt;fortran = Fortran&lt;/li&gt;&lt;li&gt;fsharp = F#&lt;/li&gt;&lt;li&gt;gams = GAMS&lt;/li&gt;&lt;li&gt;gauss = GAUSS&lt;/li&gt;&lt;li&gt;gcode = G-code&lt;/li&gt;&lt;li&gt;gherkin = Gherkin&lt;/li&gt;&lt;li&gt;glsl = GLSL&lt;/li&gt;&lt;li&gt;gml = GML&lt;/li&gt;&lt;li&gt;go = Go&lt;/li&gt;&lt;li&gt;golo = Golo&lt;/li&gt;&lt;li&gt;gradle = Gradle&lt;/li&gt;&lt;li&gt;groovy = Groovy&lt;/li&gt;&lt;li&gt;haml = Haml&lt;/li&gt;&lt;li&gt;arduino = Arduino&lt;/li&gt;&lt;li&gt;handlebars = Handlebars&lt;/li&gt;&lt;li&gt;haskell = Haskell&lt;/li&gt;&lt;li&gt;haxe = Haxe&lt;/li&gt;&lt;li&gt;hsp = HSP&lt;/li&gt;&lt;li&gt;htmlbars = HTMLBars&lt;/li&gt;&lt;li&gt;http = HTTP&lt;/li&gt;&lt;li&gt;hy = Hy&lt;/li&gt;&lt;li&gt;inform7 = Inform 7&lt;/li&gt;&lt;li&gt;arduino = Ini, TOML&lt;/li&gt;&lt;li&gt;irpf90 = IRPF90&lt;/li&gt;&lt;li&gt;isbl = ISBL&lt;/li&gt;&lt;li&gt;java = Java&lt;/li&gt;&lt;li&gt;javascript = Javascript&lt;/li&gt;&lt;li&gt;jboss-cli = jboss-cli&lt;/li&gt;&lt;li&gt;json = JSON&lt;/li&gt;&lt;li&gt;julia-repl = Julia REPL&lt;/li&gt;&lt;li&gt;julia = Julia&lt;/li&gt;&lt;li&gt;kotlin = Kotlin&lt;/li&gt;&lt;li&gt;lasso = Lasso&lt;/li&gt;&lt;li&gt;ldif = LDIF&lt;/li&gt;&lt;li&gt;leaf = Leaf&lt;/li&gt;&lt;li&gt;less = Less&lt;/li&gt;&lt;li&gt;lisp = Lisp&lt;/li&gt;&lt;li&gt;livecodeserver = LiveCode&lt;/li&gt;&lt;li&gt;livescript = LiveScript&lt;/li&gt;&lt;li&gt;llvm = LLVM IR&lt;/li&gt;&lt;li&gt;lsl = Linden Scripting Language&lt;/li&gt;&lt;li&gt;lua = Lua&lt;/li&gt;&lt;li&gt;makefile = Makefile&lt;/li&gt;&lt;li&gt;markdown = Markdown&lt;/li&gt;&lt;li&gt;mathematica = Mathematica&lt;/li&gt;&lt;li&gt;matlab = Matlab&lt;/li&gt;&lt;li&gt;maxima = Maxima&lt;/li&gt;&lt;li&gt;mel = MEL&lt;/li&gt;&lt;li&gt;mercury = Mercury&lt;/li&gt;&lt;li&gt;mipsasm = MIPS Assembly&lt;/li&gt;&lt;li&gt;mizar = Mizar&lt;/li&gt;&lt;li&gt;mojolicious = Mojolicious&lt;/li&gt;&lt;li&gt;monkey = Monkey&lt;/li&gt;&lt;li&gt;moonscript = MoonScript&lt;/li&gt;&lt;li&gt;n1ql = N1QL&lt;/li&gt;&lt;li&gt;nginx = Nginx&lt;/li&gt;&lt;li&gt;nimrod = Nimrod&lt;/li&gt;&lt;li&gt;nix = Nix&lt;/li&gt;&lt;li&gt;nsis = NSIS&lt;/li&gt;&lt;li&gt;objectivec = Objective-C&lt;/li&gt;&lt;li&gt;ocaml = OCaml&lt;/li&gt;&lt;li&gt;openscad = OpenSCAD&lt;/li&gt;&lt;li&gt;oxygene = Oxygene&lt;/li&gt;&lt;li&gt;parser3 = Parser3&lt;/li&gt;&lt;li&gt;perl = Perl&lt;/li&gt;&lt;li&gt;pf = pf&lt;/li&gt;&lt;li&gt;pgsql = PostgreSQL&lt;/li&gt;&lt;li&gt;php = PHP&lt;/li&gt;&lt;li&gt;plaintext = plaintext&lt;/li&gt;&lt;li&gt;pony = Pony&lt;/li&gt;&lt;li&gt;powershell = PowerShell&lt;/li&gt;&lt;li&gt;processing = Processing&lt;/li&gt;&lt;li&gt;profile = Python profile&lt;/li&gt;&lt;li&gt;prolog = Prolog&lt;/li&gt;&lt;li&gt;properties = Properties&lt;/li&gt;&lt;li&gt;protobuf = Protocol Buffers&lt;/li&gt;&lt;li&gt;puppet = Puppet&lt;/li&gt;&lt;li&gt;purebasic = PureBASIC&lt;/li&gt;&lt;li&gt;python = Python&lt;/li&gt;&lt;li&gt;q = Q&lt;/li&gt;&lt;li&gt;qml = QML&lt;/li&gt;&lt;li&gt;r = R&lt;/li&gt;&lt;li&gt;reasonml = ReasonML&lt;/li&gt;&lt;li&gt;rib = RenderMan RIB&lt;/li&gt;&lt;li&gt;roboconf = Roboconf&lt;/li&gt;&lt;li&gt;routeros = Microtik RouterOS Script&lt;/li&gt;&lt;li&gt;rsl = RenderMan RSL&lt;/li&gt;&lt;li&gt;ruby = Ruby&lt;/li&gt;&lt;li&gt;ruleslanguage = Oracle Rules Language&lt;/li&gt;&lt;li&gt;rust = Rust&lt;/li&gt;&lt;li&gt;sas = SAS&lt;/li&gt;&lt;li&gt;scala = Scala&lt;/li&gt;&lt;li&gt;scheme = Scheme&lt;/li&gt;&lt;li&gt;scilab = Scilab&lt;/li&gt;&lt;li&gt;scss = SCSS&lt;/li&gt;&lt;li&gt;shell = Shell Session&lt;/li&gt;&lt;li&gt;smali = Smali&lt;/li&gt;&lt;li&gt;smalltalk = Smalltalk&lt;/li&gt;&lt;li&gt;sml = SML&lt;/li&gt;&lt;li&gt;sqf = SQF&lt;/li&gt;&lt;li&gt;sql = SQL&lt;/li&gt;&lt;li&gt;stan = Stan&lt;/li&gt;&lt;li&gt;stata = Stata&lt;/li&gt;&lt;li&gt;step21 = Step Part 21&lt;/li&gt;&lt;li&gt;stylus = Stylus&lt;/li&gt;&lt;li&gt;subunit = SubUnit&lt;/li&gt;&lt;li&gt;swift = Swift&lt;/li&gt;&lt;li&gt;taggerscript = Tagger Script&lt;/li&gt;&lt;li&gt;tap = Test Anything Protocol&lt;/li&gt;&lt;li&gt;tcl = Tcl&lt;/li&gt;&lt;li&gt;tex = TeX&lt;/li&gt;&lt;li&gt;thrift = Thrift&lt;/li&gt;&lt;li&gt;tp = TP&lt;/li&gt;&lt;li&gt;twig = Twig&lt;/li&gt;&lt;li&gt;typescript = TypeScript&lt;/li&gt;&lt;li&gt;vala = Vala&lt;/li&gt;&lt;li&gt;vbnet = VB.NET&lt;/li&gt;&lt;li&gt;vbscript-html = VBScript in HTML&lt;/li&gt;&lt;li&gt;vbscript = VBScript&lt;/li&gt;&lt;li&gt;verilog = Verilog&lt;/li&gt;&lt;li&gt;vhdl = VHDL&lt;/li&gt;&lt;li&gt;vim = Vim Script&lt;/li&gt;&lt;li&gt;x86asm = Intel x86 Assembly&lt;/li&gt;&lt;li&gt;xl = XL&lt;/li&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;li&gt;xquery = XQuery&lt;/li&gt;&lt;li&gt;yaml = YAML&lt;/li&gt;&lt;li&gt;zephir = Zephir&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "available")
    protected String available;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The syntax highlighter evaluates the degree of reliability with which it recognizes a language with a value ranging from 0 to 1000 points. This value determines the reliability level starting from which it should highlight syntax for a recognized language. The higher the value, the more closely the content found must match the criteria.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "relevance")
    protected Integer relevance;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the font size for syntax highlighting to the specified value.&#13;
     *                         You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFontSize() {
        if (fontSize == null) {
            return "10px";
        } else {
            return fontSize;
        }
    }

    /**
     * Sets the value of the fontSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFontSize()
     */
    public void setFontSize(String value) {
        this.fontSize = value;
    }

    public boolean isSetFontSize() {
        return (this.fontSize!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected font should be obtained from your operating system or from the "templates/fonts" folder (in your webPDF installation path).&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;system = It will be possible to select from the fonts available system-wide.&lt;/li&gt;&lt;li&gt;folder =It will be possible to select from the fonts in "templates/fonts".&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FontOriginModeType }
     *     
     */
    public FontOriginModeType getFontOrigin() {
        if (fontOrigin == null) {
            return FontOriginModeType.SYSTEM;
        } else {
            return fontOrigin;
        }
    }

    /**
     * Sets the value of the fontOrigin property.
     * 
     * @param value
     *     allowed object is
     *     {@link FontOriginModeType }
     *     
     * @see #getFontOrigin()
     */
    public void setFontOrigin(FontOriginModeType value) {
        this.fontOrigin = value;
    }

    public boolean isSetFontOrigin() {
        return (this.fontOrigin!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the font that should be used for syntax highlighting. If you select "folder" for the "fontOrigin" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the "Fira Code" font will be used automatically.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFontFamily() {
        if (fontFamily == null) {
            return "";
        } else {
            return fontFamily;
        }
    }

    /**
     * Sets the value of the fontFamily property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFontFamily()
     */
    public void setFontFamily(String value) {
        this.fontFamily = value;
    }

    public boolean isSetFontFamily() {
        return (this.fontFamily!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to configure the word wrap behaviour during highlighting&#13;
     *                         Possible values:&#13;
     *                         &lt;ul&gt;&lt;li&gt;auto = Automatic word wrap if necessary.&lt;/li&gt;&lt;li&gt;none = Suppress the addition of extra line breaks.&lt;/li&gt;&lt;li&gt;word = Line breaks allowed only after words.&lt;/li&gt;&lt;li&gt;all = Line breaks allowed unconditionally.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TextWrapModeType }
     *     
     */
    public TextWrapModeType getWordBreak() {
        if (wordBreak == null) {
            return TextWrapModeType.AUTO;
        } else {
            return wordBreak;
        }
    }

    /**
     * Sets the value of the wordBreak property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextWrapModeType }
     *     
     * @see #getWordBreak()
     */
    public void setWordBreak(TextWrapModeType value) {
        this.wordBreak = value;
    }

    public boolean isSetWordBreak() {
        return (this.wordBreak!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", line numbers are added before the code.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLineNumbers() {
        if (lineNumbers == null) {
            return true;
        } else {
            return lineNumbers;
        }
    }

    /**
     * Sets the value of the lineNumbers property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLineNumbers()
     */
    public void setLineNumbers(boolean value) {
        this.lineNumbers = value;
    }

    public boolean isSetLineNumbers() {
        return (this.lineNumbers!= null);
    }

    public void unsetLineNumbers() {
        this.lineNumbers = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the line height. You can use any of the following units:&#13;
     *                         &lt;ul&gt;&lt;li&gt;px = Pixels&lt;/li&gt;&lt;li&gt;cm = Centimeters&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;li&gt;pt = Points&lt;/li&gt;&lt;li&gt;pc = Pica&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLineHeight() {
        if (lineHeight == null) {
            return "12px";
        } else {
            return lineHeight;
        }
    }

    /**
     * Sets the value of the lineHeight property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLineHeight()
     */
    public void setLineHeight(String value) {
        this.lineHeight = value;
    }

    public boolean isSetLineHeight() {
        return (this.lineHeight!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select a specific language for highlighting recognition. You can select one of the languages listed for the "available" parameter. If you do not set this value, the system will attempt to automatically select an appropriate language from the list of available languages.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        if (language == null) {
            return "";
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to specify the languages to which the syntax highlighted should be limited. You can enter multiple languages by separating them with a comma ("java,cpp"). If you do not specify a value, all the languages listed below will be recognized.&#13;
     *                         You can select any of the following languages:&#13;
     *                         &lt;ul&gt;&lt;li&gt;abnf = Augmented Backus-Naur form&lt;/li&gt;&lt;li&gt;accesslog = Apache/Nginx Access Logs&lt;/li&gt;&lt;li&gt;actionscript = ActionScript&lt;/li&gt;&lt;li&gt;ada = Ada&lt;/li&gt;&lt;li&gt;angelscript = AngelScript&lt;/li&gt;&lt;li&gt;apache = Apache configuration language&lt;/li&gt;&lt;li&gt;applescript = AppleScript&lt;/li&gt;&lt;li&gt;arcade = ArcGIS Arcade&lt;/li&gt;&lt;li&gt;arduino = Arduino&lt;/li&gt;&lt;li&gt;armasm = ARM Assembly&lt;/li&gt;&lt;li&gt;asciidoc = AsciiDoc&lt;/li&gt;&lt;li&gt;aspectj = AspectJ&lt;/li&gt;&lt;li&gt;autohotkey = AutoHotkey&lt;/li&gt;&lt;li&gt;autoit = AutoIt&lt;/li&gt;&lt;li&gt;avrasm = AVR Assembler&lt;/li&gt;&lt;li&gt;awk = Awk&lt;/li&gt;&lt;li&gt;axapta = Axapta&lt;/li&gt;&lt;li&gt;bash = Bash&lt;/li&gt;&lt;li&gt;basic = Basic&lt;/li&gt;&lt;li&gt;bnf = Backus-Naur Form&lt;/li&gt;&lt;li&gt;brainfuck = Brainfuck&lt;/li&gt;&lt;li&gt;cal = C/AL&lt;/li&gt;&lt;li&gt;capnproto = Cap'n Proto&lt;/li&gt;&lt;li&gt;ceylon = Ceylon&lt;/li&gt;&lt;li&gt;clean = Clean&lt;/li&gt;&lt;li&gt;clojure-repl = Clojure REPL&lt;/li&gt;&lt;li&gt;clojure = Clojure&lt;/li&gt;&lt;li&gt;cmake = CMake&lt;/li&gt;&lt;li&gt;coffeescript = CoffeeScript&lt;/li&gt;&lt;li&gt;coq = Coq&lt;/li&gt;&lt;li&gt;cos = Caché Object Script&lt;/li&gt;&lt;li&gt;cpp = C++&lt;/li&gt;&lt;li&gt;crmsh = crmsh&lt;/li&gt;&lt;li&gt;crystal = Crystal&lt;/li&gt;&lt;li&gt;cs = C#&lt;/li&gt;&lt;li&gt;csp = CSP&lt;/li&gt;&lt;li&gt;css = CSS&lt;/li&gt;&lt;li&gt;d = D&lt;/li&gt;&lt;li&gt;dart = Dart&lt;/li&gt;&lt;li&gt;delphi = Delphi&lt;/li&gt;&lt;li&gt;diff = Diff&lt;/li&gt;&lt;li&gt;django = Django&lt;/li&gt;&lt;li&gt;dns = DNS Zone file&lt;/li&gt;&lt;li&gt;dockerfile = Dockerfile&lt;/li&gt;&lt;li&gt;dos = DOS .bat&lt;/li&gt;&lt;li&gt;dsconfig = dsconfig&lt;/li&gt;&lt;li&gt;dts = Device Tree&lt;/li&gt;&lt;li&gt;dust = Dust&lt;/li&gt;&lt;li&gt;ebnf = Extended Backus-Naur Form&lt;/li&gt;&lt;li&gt;elixir = Elixir&lt;/li&gt;&lt;li&gt;elm = Elm&lt;/li&gt;&lt;li&gt;erb = Embedded Ruby&lt;/li&gt;&lt;li&gt;erlang-repl = Erlang REPL&lt;/li&gt;&lt;li&gt;erlang = Erlang&lt;/li&gt;&lt;li&gt;excel = Excel&lt;/li&gt;&lt;li&gt;fix = FIX&lt;/li&gt;&lt;li&gt;flix = FLIX&lt;/li&gt;&lt;li&gt;fortran = Fortran&lt;/li&gt;&lt;li&gt;fsharp = F#&lt;/li&gt;&lt;li&gt;gams = GAMS&lt;/li&gt;&lt;li&gt;gauss = GAUSS&lt;/li&gt;&lt;li&gt;gcode = G-code&lt;/li&gt;&lt;li&gt;gherkin = Gherkin&lt;/li&gt;&lt;li&gt;glsl = GLSL&lt;/li&gt;&lt;li&gt;gml = GML&lt;/li&gt;&lt;li&gt;go = Go&lt;/li&gt;&lt;li&gt;golo = Golo&lt;/li&gt;&lt;li&gt;gradle = Gradle&lt;/li&gt;&lt;li&gt;groovy = Groovy&lt;/li&gt;&lt;li&gt;haml = Haml&lt;/li&gt;&lt;li&gt;arduino = Arduino&lt;/li&gt;&lt;li&gt;handlebars = Handlebars&lt;/li&gt;&lt;li&gt;haskell = Haskell&lt;/li&gt;&lt;li&gt;haxe = Haxe&lt;/li&gt;&lt;li&gt;hsp = HSP&lt;/li&gt;&lt;li&gt;htmlbars = HTMLBars&lt;/li&gt;&lt;li&gt;http = HTTP&lt;/li&gt;&lt;li&gt;hy = Hy&lt;/li&gt;&lt;li&gt;inform7 = Inform 7&lt;/li&gt;&lt;li&gt;arduino = Ini, TOML&lt;/li&gt;&lt;li&gt;irpf90 = IRPF90&lt;/li&gt;&lt;li&gt;isbl = ISBL&lt;/li&gt;&lt;li&gt;java = Java&lt;/li&gt;&lt;li&gt;javascript = Javascript&lt;/li&gt;&lt;li&gt;jboss-cli = jboss-cli&lt;/li&gt;&lt;li&gt;json = JSON&lt;/li&gt;&lt;li&gt;julia-repl = Julia REPL&lt;/li&gt;&lt;li&gt;julia = Julia&lt;/li&gt;&lt;li&gt;kotlin = Kotlin&lt;/li&gt;&lt;li&gt;lasso = Lasso&lt;/li&gt;&lt;li&gt;ldif = LDIF&lt;/li&gt;&lt;li&gt;leaf = Leaf&lt;/li&gt;&lt;li&gt;less = Less&lt;/li&gt;&lt;li&gt;lisp = Lisp&lt;/li&gt;&lt;li&gt;livecodeserver = LiveCode&lt;/li&gt;&lt;li&gt;livescript = LiveScript&lt;/li&gt;&lt;li&gt;llvm = LLVM IR&lt;/li&gt;&lt;li&gt;lsl = Linden Scripting Language&lt;/li&gt;&lt;li&gt;lua = Lua&lt;/li&gt;&lt;li&gt;makefile = Makefile&lt;/li&gt;&lt;li&gt;markdown = Markdown&lt;/li&gt;&lt;li&gt;mathematica = Mathematica&lt;/li&gt;&lt;li&gt;matlab = Matlab&lt;/li&gt;&lt;li&gt;maxima = Maxima&lt;/li&gt;&lt;li&gt;mel = MEL&lt;/li&gt;&lt;li&gt;mercury = Mercury&lt;/li&gt;&lt;li&gt;mipsasm = MIPS Assembly&lt;/li&gt;&lt;li&gt;mizar = Mizar&lt;/li&gt;&lt;li&gt;mojolicious = Mojolicious&lt;/li&gt;&lt;li&gt;monkey = Monkey&lt;/li&gt;&lt;li&gt;moonscript = MoonScript&lt;/li&gt;&lt;li&gt;n1ql = N1QL&lt;/li&gt;&lt;li&gt;nginx = Nginx&lt;/li&gt;&lt;li&gt;nimrod = Nimrod&lt;/li&gt;&lt;li&gt;nix = Nix&lt;/li&gt;&lt;li&gt;nsis = NSIS&lt;/li&gt;&lt;li&gt;objectivec = Objective-C&lt;/li&gt;&lt;li&gt;ocaml = OCaml&lt;/li&gt;&lt;li&gt;openscad = OpenSCAD&lt;/li&gt;&lt;li&gt;oxygene = Oxygene&lt;/li&gt;&lt;li&gt;parser3 = Parser3&lt;/li&gt;&lt;li&gt;perl = Perl&lt;/li&gt;&lt;li&gt;pf = pf&lt;/li&gt;&lt;li&gt;pgsql = PostgreSQL&lt;/li&gt;&lt;li&gt;php = PHP&lt;/li&gt;&lt;li&gt;plaintext = plaintext&lt;/li&gt;&lt;li&gt;pony = Pony&lt;/li&gt;&lt;li&gt;powershell = PowerShell&lt;/li&gt;&lt;li&gt;processing = Processing&lt;/li&gt;&lt;li&gt;profile = Python profile&lt;/li&gt;&lt;li&gt;prolog = Prolog&lt;/li&gt;&lt;li&gt;properties = Properties&lt;/li&gt;&lt;li&gt;protobuf = Protocol Buffers&lt;/li&gt;&lt;li&gt;puppet = Puppet&lt;/li&gt;&lt;li&gt;purebasic = PureBASIC&lt;/li&gt;&lt;li&gt;python = Python&lt;/li&gt;&lt;li&gt;q = Q&lt;/li&gt;&lt;li&gt;qml = QML&lt;/li&gt;&lt;li&gt;r = R&lt;/li&gt;&lt;li&gt;reasonml = ReasonML&lt;/li&gt;&lt;li&gt;rib = RenderMan RIB&lt;/li&gt;&lt;li&gt;roboconf = Roboconf&lt;/li&gt;&lt;li&gt;routeros = Microtik RouterOS Script&lt;/li&gt;&lt;li&gt;rsl = RenderMan RSL&lt;/li&gt;&lt;li&gt;ruby = Ruby&lt;/li&gt;&lt;li&gt;ruleslanguage = Oracle Rules Language&lt;/li&gt;&lt;li&gt;rust = Rust&lt;/li&gt;&lt;li&gt;sas = SAS&lt;/li&gt;&lt;li&gt;scala = Scala&lt;/li&gt;&lt;li&gt;scheme = Scheme&lt;/li&gt;&lt;li&gt;scilab = Scilab&lt;/li&gt;&lt;li&gt;scss = SCSS&lt;/li&gt;&lt;li&gt;shell = Shell Session&lt;/li&gt;&lt;li&gt;smali = Smali&lt;/li&gt;&lt;li&gt;smalltalk = Smalltalk&lt;/li&gt;&lt;li&gt;sml = SML&lt;/li&gt;&lt;li&gt;sqf = SQF&lt;/li&gt;&lt;li&gt;sql = SQL&lt;/li&gt;&lt;li&gt;stan = Stan&lt;/li&gt;&lt;li&gt;stata = Stata&lt;/li&gt;&lt;li&gt;step21 = Step Part 21&lt;/li&gt;&lt;li&gt;stylus = Stylus&lt;/li&gt;&lt;li&gt;subunit = SubUnit&lt;/li&gt;&lt;li&gt;swift = Swift&lt;/li&gt;&lt;li&gt;taggerscript = Tagger Script&lt;/li&gt;&lt;li&gt;tap = Test Anything Protocol&lt;/li&gt;&lt;li&gt;tcl = Tcl&lt;/li&gt;&lt;li&gt;tex = TeX&lt;/li&gt;&lt;li&gt;thrift = Thrift&lt;/li&gt;&lt;li&gt;tp = TP&lt;/li&gt;&lt;li&gt;twig = Twig&lt;/li&gt;&lt;li&gt;typescript = TypeScript&lt;/li&gt;&lt;li&gt;vala = Vala&lt;/li&gt;&lt;li&gt;vbnet = VB.NET&lt;/li&gt;&lt;li&gt;vbscript-html = VBScript in HTML&lt;/li&gt;&lt;li&gt;vbscript = VBScript&lt;/li&gt;&lt;li&gt;verilog = Verilog&lt;/li&gt;&lt;li&gt;vhdl = VHDL&lt;/li&gt;&lt;li&gt;vim = Vim Script&lt;/li&gt;&lt;li&gt;x86asm = Intel x86 Assembly&lt;/li&gt;&lt;li&gt;xl = XL&lt;/li&gt;&lt;li&gt;xml = XML&lt;/li&gt;&lt;li&gt;xquery = XQuery&lt;/li&gt;&lt;li&gt;yaml = YAML&lt;/li&gt;&lt;li&gt;zephir = Zephir&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAvailable() {
        if (available == null) {
            return "";
        } else {
            return available;
        }
    }

    /**
     * Sets the value of the available property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getAvailable()
     */
    public void setAvailable(String value) {
        this.available = value;
    }

    public boolean isSetAvailable() {
        return (this.available!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p117921_="https://jakarta.ee/xml/ns/jaxb" xmlns:p71612_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The syntax highlighter evaluates the degree of reliability with which it recognizes a language with a value ranging from 0 to 1000 points. This value determines the reliability level starting from which it should highlight syntax for a recognized language. The higher the value, the more closely the content found must match the criteria.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRelevance() {
        if (relevance == null) {
            return  90;
        } else {
            return relevance;
        }
    }

    /**
     * Sets the value of the relevance property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getRelevance()
     */
    public void setRelevance(int value) {
        this.relevance = value;
    }

    public boolean isSetRelevance() {
        return (this.relevance!= null);
    }

    public void unsetRelevance() {
        this.relevance = null;
    }

}
